package w83b.w83bDAO;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

import org.apache.commons.lang.StringUtils;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bCentroTrabajoBean;
import w83b.w83bBeans.W83bConveniosBean;
import w83b.w83bBeans.W83bDatosEscrutiniosBean;
import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bHistorialActaBean;
import w83b.w83bBeans.W83bImpugnacionesBean;
import w83b.w83bBeans.W83bIncidenciaActaBean;
import w83b.w83bBeans.W83bListaDelegadosBean;
import w83b.w83bBeans.W83bListaDiferenciasBean;
import w83b.w83bBeans.W83bListaEscrutiniosBean;
import w83b.w83bBeans.W83bListaSindicatosBean;
import w83b.w83bBeans.W83bPapeletasBean;
import w83b.w83bBeans.W83bPreavisosBean;
import w83b.w83bBeans.W83bTipoDocumentoBean;
import w83b.w83bBeans.W83bTramiteActaBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bDAO.w83bConstantesBD.W83bActasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bActasVistaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bArbitrosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bCentroTrabajoBD;
import w83b.w83bDAO.w83bConstantesBD.W83bCentroTrabajoVistaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bCierreBD;
import w83b.w83bDAO.w83bConstantesBD.W83bColegiosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bConveniosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bDelegadosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bDiferenciasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bEscrutiniosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bImpugnacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bIncidenciasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bListadosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bMotivosBajaActaBD;
import w83b.w83bDAO.w83bConstantesBD.W83bMotivosBajaDelegadoBD;
import w83b.w83bDAO.w83bConstantesBD.W83bNumDelegadosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bPapeletasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bPreavisosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bSindicatosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bTiposDocumentosVistaBD;
import w83b.w83bManager.W83bComunes;
import w83b.w83bManager.W83bIComunes;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesLibroRegistro.W83bLibroRegistro;
import w83b.w83bUtilidadesLibroRegistro.W83bLibroRegistroException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;


public class W83bActasDAO implements W83bIActasDAO {
	
	public java.lang.String buscarFechaCierre(java.util.HashMap param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT  MAX(");
		strSql.append("TO_NUMBER (");
		strSql.append(W83bCierreBD.anocierre);
		strSql.append("|| DECODE (LENGTH (TO_CHAR (");
		strSql.append(W83bCierreBD.mescierre);
		strSql.append(")),1, '0' || ");
		strSql.append(W83bCierreBD.mescierre);
		strSql.append(",");
		strSql.append(W83bCierreBD.mescierre);
		strSql.append("))");
		strSql.append(") FROM ");
		strSql.append(W83bCierreBD.tablacierre);
		strSql.append(" WHERE ");
		if (W83bClsConstantes.CONSTANTE_ALAVA.equals((String)param.get("territorio"))){
			strSql.append(W83bCierreBD.cierrealava).append("=?");
		}else if (W83bClsConstantes.CONSTANTE_BIZKAIA.equals((String)param.get("territorio"))){
			strSql.append(W83bCierreBD.cierrebizkaia).append("=?");
		}else if (W83bClsConstantes.CONSTANTE_GIPUZKOA.equals((String)param.get("territorio"))){
			strSql.append(W83bCierreBD.cierregipuzkoa).append("=?");
		}
		
		params.add(W83bClsConstantes.CONSTANTE_SI);
		
		List listaCierre = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		return listaCierre.get(0).toString().substring(0, 4)+"|"+listaCierre.get(0).toString().substring(4, 6);	
	}
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIMantenimientosDAO#buscarAgrupaciones(w83b.w83bBeans.W83bAgrupacionesBean)
	 */
	public java.util.List buscarActas(w83b.w83bBeans.W83bActasBean param,boolean contar) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		boolean buscoCentro=false;
		if(StringUtils.isNotEmpty(param.getCentroTrabajo().getCifnif())||StringUtils.isNotEmpty(param.getCentroTrabajo().getNumCentro())||
				StringUtils.isNotEmpty(param.getCentroTrabajo().getRazonSocial())||StringUtils.isNotEmpty(param.getCentroTrabajo().getCodMunicipio())
				||StringUtils.isNotEmpty(param.getCentroTrabajo().getCodTerritorio()) ){
			buscoCentro = true;
		}
		
		if(contar){
			strSql.append("SELECT COUNT(distinct(");
			strSql.append(W83bActasVistaBD.NACTA).append(")) ");
		}else{
			strSql.append("SELECT ");
			strSql.append("DISTINCT(");
			strSql.append(" ACTAS.").append(W83bActasVistaBD.NACTA).append("), ");
			strSql.append(" ACTAS.").append(W83bActasVistaBD.NREGISTRO).append(", ");
			strSql.append(" ACTAS.").append(W83bActasVistaBD.NPREAVISO).append(", ");

			strSql.append(" upper(centros.").append(W83bCentroTrabajoBD.razonSocial).append(") AS ").append(W83bActasVistaBD.RAZONSOCIAL).append(", ");
			strSql.append(" centros.").append(W83bCentroTrabajoBD.codigoCentro).append(" AS ").append(W83bActasVistaBD.NCENTRO).append(", ");
			strSql.append(" centros.").append(W83bCentroTrabajoBD.codNifCif).append(" AS ").append(W83bActasVistaBD.CIF).append(", ");
			strSql.append(" centros.").append(W83bCentroTrabajoBD.ncentroTrab).append(" AS ").append(W83bActasVistaBD.NCENTROTRABAJO).append(", ");
			strSql.append(" centros.").append(W83bCentroTrabajoBD.codProvinciaCentro).append(" AS ").append(W83bCentroTrabajoBD.codProvinciaCentro).append(", ");
			strSql.append(" centros.").append(W83bCentroTrabajoBD.codMunicipioCentro).append(" AS ").append(W83bCentroTrabajoBD.codMunicipioCentro).append(", ");
			

			strSql.append(" ").append(" TO_CHAR(ACTAS.");
			strSql.append(W83bActasVistaBD.FELECCION).append(",?) AS ").append(W83bActasVistaBD.FELECCION).append("COLUMN");
			strSql.append(", ").append(" ACTAS.");
			strSql.append(W83bActasVistaBD.FELECCION).append(" ");
			strSql.append(", TO_CHAR(");
			strSql.append(" ACTAS.").append(W83bActasVistaBD.FCOMISION).append(",?) AS ").append(W83bActasVistaBD.FCOMISION);
			strSql.append(", ");
			strSql.append(" ACTAS.").append(W83bActasVistaBD.NELECTORES).append(", ");
			strSql.append(" ACTAS.").append(W83bActasVistaBD.codReg).append(", ");
			strSql.append(" ACTAS.").append(W83bActasVistaBD.anyoReg).append(", ");
			strSql.append(" ACTAS.").append(W83bActasVistaBD.versionacta).append(", ");
			strSql.append(" ACTAS.").append(W83bActasVistaBD.validada).append(", ");
			strSql.append(" ACTAS.").append(W83bActasVistaBD.BAJA).append(", ");
			strSql.append(" ACTAS.").append(W83bActasVistaBD.codTerritorioActa).append(", ");
			strSql.append(" ACTAS.").append(W83bActasVistaBD.anyoActa).append(", ");
			strSql.append(" ACTAS.").append(W83bActasVistaBD.numActa).append(", ");
			strSql.append(" ACTAS.").append(W83bActasVistaBD.codTerritorioPreaviso).append(", ");
			strSql.append(" ACTAS.").append(W83bActasVistaBD.anyoPreaviso).append(", ");
			strSql.append(" ACTAS.").append(W83bActasVistaBD.fecRegDef).append(", ");
			strSql.append(" ACTAS.").append(W83bActasVistaBD.numPreaviso);
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		
		strSql.append(" FROM ").append(W83bActasVistaBD.w83bvistaactasSinCentro).append(" ACTAS ");
		if(!contar||buscoCentro){
			strSql.append(" ,").append(W83bCentroTrabajoBD.tablaCTDesa).append(" centros");
			strSql.append(" WHERE ").append(" centros.").append(W83bCentroTrabajoBD.codigoCentro);
			strSql.append("(+) = ").append(" ACTAS.").append(W83bActasVistaBD.CODCENTROACTA);
		}else{
			strSql.append(" WHERE ");
		}
		
		if(StringUtils.isNotEmpty(param.getNumActaTerritorioDesde())){
			if(!contar||buscoCentro){
				strSql.append(" AND ");
			}
			strSql.append(" ").append(" ACTAS.").append(W83bActasVistaBD.codTerritorioActa).append(" = ?");
			params.add(param.getNumActaTerritorioDesde());
		}else{
			if(!contar||buscoCentro){
				strSql.append(" AND ");
			}
			strSql.append(" ").append(" (ACTAS.").append(W83bActasVistaBD.codTerritorioActa).append(" = ?");
			strSql.append(" OR ").append(" ACTAS.").append(W83bActasVistaBD.codTerritorioActa).append(" = ?");
			strSql.append(" OR ").append(" ACTAS.").append(W83bActasVistaBD.codTerritorioActa).append(" = ?)");
			
			params.add(W83bClsConstantes.CONSTANTE_ALAVA);
			params.add(W83bClsConstantes.CONSTANTE_BIZKAIA);
			params.add(W83bClsConstantes.CONSTANTE_GIPUZKOA);
			
		}
		String desde = param.getNumActaAnyoDesde();
		String hasta = param.getNumActaAnyoHasta();
		String numDesde = param.getNumActaNumeroDesde();
		String numHasta = param.getNumActaNumeroHasta();
		if(StringUtils.isEmpty(param.getNumActaAnyoDesde())){
			desde = "0000";
		}
		if(StringUtils.isEmpty(param.getNumActaAnyoHasta())){
			hasta = "9999";
		}
		if(StringUtils.isEmpty(param.getNumActaNumeroDesde())){
			numDesde = "000000";
		}else if(6>param.getNumActaNumeroDesde().length()){
			for(int i = param.getNumActaNumeroDesde().length(),size = 6;i<size;i++){
				numDesde = "0"+numDesde;//NOPMD
			}
		}
		if(StringUtils.isEmpty(param.getNumActaNumeroHasta())){
			numHasta = "999999";
		}else if(6>param.getNumActaNumeroHasta().length()){
			for(int i = param.getNumActaNumeroHasta().length(),size = 6;i<size;i++){
				numHasta = "0"+numHasta;//NOPMD
			}
		}
		desde = desde + numDesde;//NOPMD
		hasta = hasta + numHasta;//NOPMD
		strSql.append(" AND ");				
		strSql.append(" ACTAS.").append(W83bActasVistaBD.NACTACOMPLETO).append(" >= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(desde)));
		strSql.append(" AND ");				
		strSql.append(" ACTAS.").append(W83bActasVistaBD.NACTACOMPLETO).append(" <= ?");
		params.add(BigDecimal.valueOf(Long.parseLong(hasta)));
		//fin NMERO DE ACTA
		
		//NMERO DE REGISTRO
		if(W83bClsConstantes.CONSTANTE_NO.equalsIgnoreCase(param.getSinRegDefinitivo())){
			if(StringUtils.isNotEmpty(param.getNumRegTerritorioDesde())){
				strSql.append(" AND ");
				strSql.append(" ").append(" ACTAS.").append(W83bActasVistaBD.codTerritorioReg).append(" = ?");
				params.add(param.getNumRegTerritorioDesde());
			}else{
				strSql.append(" AND ");
				strSql.append(" ").append(" (ACTAS.").append(W83bActasVistaBD.codTerritorioReg).append(" = ?");
				strSql.append(" OR ").append(" ACTAS.").append(W83bActasVistaBD.codTerritorioReg).append(" = ?");
				strSql.append(" OR ").append(" ACTAS.").append(W83bActasVistaBD.codTerritorioReg).append(" = ?)");
				
				params.add(W83bClsConstantes.CONSTANTE_ALAVA);
				params.add(W83bClsConstantes.CONSTANTE_BIZKAIA);
				params.add(W83bClsConstantes.CONSTANTE_GIPUZKOA);
				
			}
			desde = param.getNumRegAnyoDesde();
			hasta = param.getNumRegAnyoHasta();
			numDesde = param.getNumRegNumeroDesde();
			numHasta = param.getNumRegNumeroHasta();
			if(StringUtils.isEmpty(param.getNumRegAnyoDesde())){
				desde = "0000";
			}
			if(StringUtils.isEmpty(param.getNumRegAnyoHasta())){
				hasta = "9999";
			}
			if(StringUtils.isEmpty(param.getNumRegNumeroDesde())){
				numDesde = "000000";
			}else if(6>param.getNumRegNumeroDesde().length()){
				for(int i = param.getNumRegNumeroDesde().length(),size = 6;i<size;i++){
					numDesde = "0"+numDesde;//NOPMD
				}
			}
			if(StringUtils.isEmpty(param.getNumRegNumeroHasta())){
				numHasta = "999999";
			}else if(6>param.getNumRegNumeroHasta().length()){
				for(int i = param.getNumRegNumeroHasta().length(),size = 6;i<size;i++){
					numHasta = "0"+numHasta;//NOPMD
				}
			}
			desde = desde + numDesde;//NOPMD
			hasta = hasta + numHasta;//NOPMD
				strSql.append(" AND ");				
			strSql.append(" ACTAS.").append(W83bActasVistaBD.NREGISTROCOMPLETO).append(" >= ?");
			params.add(BigDecimal.valueOf(Long.parseLong(desde)));
			strSql.append(" AND ");				
			strSql.append(" ACTAS.").append(W83bActasVistaBD.NREGISTROCOMPLETO).append(" <= ?");
			params.add(BigDecimal.valueOf(Long.parseLong(hasta)));
			
		}else if(W83bClsConstantes.CONSTANTE_SI.equalsIgnoreCase(param.getSinRegDefinitivo())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.codReg).append(" is null");
		}
		//fin NMERO DE REGISTRO
		

		
		//PREAVISO
		if(StringUtils.isNotEmpty(param.getTerritorioPreaviso())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.codTerritorioPreaviso).append(" = ?");
			params.add(param.getTerritorioPreaviso());
		}		
		
		if(StringUtils.isNotEmpty(param.getAnyoPreaviso())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.anyoPreaviso).append(" = ?");
			params.add(new Integer(param.getAnyoPreaviso()));
		}		
		
		if(StringUtils.isNotEmpty(param.getNumPreaviso())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.numPreaviso).append(" = ?");
			params.add(new Integer(param.getNumPreaviso()));
		}		
		//fin PREAVISO
		
		//FECHA ENTRADA
		if(StringUtils.isNotEmpty(param.getFechaEntradaDel())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.fentradaDate).append(" >= to_date(?,?)");
			params.add(param.getFechaEntradaDel());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		
		if(StringUtils.isNotEmpty(param.getFechaEntradaHasta())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.fentradaDate).append(" <= to_date(?,?)");
			params.add(param.getFechaEntradaHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		//fin FECHA ENTRADA
		
		//FECHA COMISIN
		if(StringUtils.isNotEmpty(param.getFechaComisionDel())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.FCOMISION).append(" >= to_date(?,?)");
			params.add(param.getFechaComisionDel());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		
		if(StringUtils.isNotEmpty(param.getFechaComisionHasta())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.FCOMISION).append(" <= to_date(?,?)");
			params.add(param.getFechaComisionHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		
		if(StringUtils.isNotEmpty(param.getSinFechaComision())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.FCOMISION).append(" is null");
		}		
		//fin FECHA COMISIN

		//FECHA ELECCIN
		if(StringUtils.isNotEmpty(param.getFechaEleccionDel())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.FELECCION).append(" >= to_date(?,?)");
			params.add(param.getFechaEleccionDel());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		
		if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.FELECCION).append(" <= to_date(?,?)");
			params.add(param.getFechaEleccionHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		//fin FECHA ELECCIN
		
		//N DE TRABAJADORES
		if(StringUtils.isNotEmpty(param.getNumElectoresDesde())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.NELECTORES).append(" >= ?");
			params.add(new Integer(param.getNumElectoresDesde()));
		}		
		
		if(StringUtils.isNotEmpty(param.getNumElectoresHasta())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.NELECTORES).append(" <= ?");
			params.add(new Integer(param.getNumElectoresHasta()));
		}		
		//fin FECHA ELECCIN
		
		//MOTIVOS BAJA
		if(StringUtils.isNotEmpty(param.getFechaBajaDel())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.fbaja).append(" >= to_date(?,?)");
			params.add(param.getFechaBajaDel());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		
		if(StringUtils.isNotEmpty(param.getFechaBajaHasta())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.fbaja).append(" <= to_date(?,?)");
			params.add(param.getFechaBajaHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}		
		
		if(StringUtils.isNotEmpty(param.getMotivoBaja())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.motBaja).append(" = ?");
			params.add(new Integer(param.getMotivoBaja()));
		}		
		//fin MOTIVOS BAJA
//		if(StringUtils.isEmpty(param.getFechaBajaDel())
//			&& StringUtils.isEmpty(param.getFechaBajaHasta())
//				  &&StringUtils.isEmpty(param.getMotivoBaja())){
//			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.fbaja).append(" IS NULL");	
//		}
		
		//CONVENIOS - INSPECCIONES - TIPO DE ACTA
		if(StringUtils.isNotEmpty(param.getConvenio())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.codconvenio).append(" = ?");
			params.add(new Integer(param.getConvenio()));
		}		
		
		if(StringUtils.isNotEmpty(param.getInspecciones())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.codInspeccion).append(" = ?");
			params.add(param.getInspecciones());
		}		
		
		if(StringUtils.isNotEmpty(param.getTipoActa())){			
			if(W83bClsConstantes.TIPO_ACTA_PARCIALES.equals((param.getTipoActa()))){
				strSql.append(" AND ACTAS.").append(W83bActasVistaBD.anyoactatotal).append(" is not null  ");				
				strSql.append(" AND ACTAS.").append(W83bActasVistaBD.nactatotal).append("  is not null  ");				
			}else{
				strSql.append(" AND ACTAS.").append(W83bActasVistaBD.anyoactatotal).append(" is null  ");				
				strSql.append(" AND ACTAS.").append(W83bActasVistaBD.nactatotal).append("  is null  ");				
			}
		}
		

		if(StringUtils.isNotEmpty(param.getFase())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.fase).append(" = ?");
			params.add(param.getFase());
		}
		
		if(StringUtils.isNotEmpty(param.getTramite())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.tramitacion).append(" = ?");
			params.add(param.getTramite());
		}
		
		if(StringUtils.isNotEmpty(param.getFechaTramiteDel())){
			strSql.append(" AND (ACTAS.").append(W83bActasVistaBD.fActualizacion).append(" >= ?");
			params.add(param.getFechaTramiteDel());
			strSql.append(" OR ACTAS.").append(W83bActasVistaBD.fModificacion).append(" >= ?");
			params.add(param.getFechaTramiteDel());
			strSql.append(")");
		}
		
		if(StringUtils.isNotEmpty(param.getFechaTramiteHasta())){
			strSql.append(" AND (ACTAS.").append(W83bActasVistaBD.fActualizacion).append(" <= to_date(?,?)");
			params.add(param.getFechaTramiteHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			strSql.append(" OR ACTAS.").append(W83bActasVistaBD.fModificacion).append(" <= to_date(?,?)");
			params.add(param.getFechaTramiteHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			strSql.append(")");
		}
		
		if(StringUtils.isNotEmpty(param.getUltTramite())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.maxFase).append(" = ?");
			params.add(param.getFase());
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.maxTram).append(" = ?");
			params.add(param.getTramite());
		}
		
		if(StringUtils.isNotEmpty(param.getActaparcial())){
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.nactatotal).append(" IS NOT NULL ");
		}
		else{
			strSql.append(" AND ACTAS.").append(W83bActasVistaBD.nactatotal).append(" IS NULL ");
		}
		
		//CENTRO DE TRABAJO
		if(!contar||buscoCentro){
			if(StringUtils.isNotEmpty(param.getCentroTrabajo().getCifnif())){
				strSql.append(" AND UPPER( centros.").append(W83bCentroTrabajoBD.codNifCif).append(") = ?");
				params.add(param.getCentroTrabajo().getCifnif().toUpperCase());
			}
			if(StringUtils.isNotEmpty(param.getCentroTrabajo().getNumCentro())){
				strSql.append(" AND centros.").append(W83bCentroTrabajoBD.ncentroTrab).append(" = ?");
				params.add(new Integer(param.getCentroTrabajo().getNumCentro()));
			}
			if(StringUtils.isNotEmpty(param.getCentroTrabajo().getRazonSocial())){
				strSql.append(" AND (UPPER(centros.").append(W83bCentroTrabajoBD.razonSocial).append(") LIKE ?");
				params.add(new StringBuffer(W83bClsConstantes.CUARENTA).append("%").append(param.getCentroTrabajo().getRazonSocial().toUpperCase()).
						append("%").toString());
				strSql.append(" or UPPER(centros.").append(W83bCentroTrabajoBD.razonSocialSCaractControl).append(") LIKE ?)");
				params.add(new StringBuffer(W83bClsConstantes.CUARENTA).append("%").append(param.getCentroTrabajo().getRazonSocial().toUpperCase()).
						append("%").toString());
			}
			if(StringUtils.isNotEmpty(param.getCentroTrabajo().getCodMunicipio())){
				strSql.append(" AND centros.").append(W83bCentroTrabajoBD.codMunicipioCentro).append(" = ?");
				params.add(new Integer(param.getCentroTrabajo().getCodMunicipio()));
			}
			if(StringUtils.isNotEmpty(param.getCentroTrabajo().getCodTerritorio())){
	//			NO SE SABE PERO SI SE FILTRA POR CODTERRITORIO VA LENTISIMO, SE HA OPTADO POR UN PLAN B
	//			NO TAN LIMPIO
				strSql.append(" AND centros.").append(W83bCentroTrabajoBD.codProvinciaCentro).append(" = ?");
	
				params.add(new Integer(param.getCentroTrabajo().getCodTerritorio()));
			}
		}
		//fin CENTRO DE TRABAJO
		
		if(param.getIdColumna()!=null&&!param.getIdColumna().equals("")){
			String[] ordenacion=param.getIdColumna().split(",");
			
			strSql.append(" ORDER BY ");
			for(int i=0;i<ordenacion.length;i++)
			{
				if(i!=0)
				{
					strSql.append(", ");
				}
					strSql.append(ordenacion[i]).append(" ").append(param.getSort());	
			}
		}
		//fin MOTIVOS BAJA
		
		
		if(contar){
			return W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		}else{			
			return W83bDataBase.executeQuery(strSql.toString(),params,W83bActasBean.class,param.getUsuarioBean(), param.getIdioma());
		}		
		
	}
	
	
	public String obtenerMunicipio(String provincia,String municipio) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		String m="";
		String p="";
		List params = new ArrayList();
		
	    strSql.append("SELECT ");
	    strSql.append(W83bListadosBD.dso).append(" AS ").append(W83bListadosBD.descmunicipio);
	    strSql.append(" FROM ");
	    strSql.append(W83bListadosBD.tablamunicipio);
	    strSql.append(" WHERE ");
	    strSql.append(W83bListadosBD.provinciaid).append("=?");
	    strSql.append(" AND ");
	    strSql.append(W83bListadosBD.id).append("=?");
	    
	    if (provincia!=null){
	    	if (provincia.length()==1){
		    	p="0"+provincia;
		    }
		    else{
		    	p=provincia;
		    }
	    }
	    
	    if (municipio!=null){
	    	  if (municipio.length()==1){
	  	    	m="00"+municipio;
	  	    }else if (municipio.length()==2){
	  	    	m="0"+municipio;
	  	    }
	  	    else{
	  	    	m=municipio;
	  	    }
	    }
	    
	    params.add(p);
	    params.add(m);
		
	    List lista = W83bDataBase.executeSimpleQuerySinTrazas(strSql.toString(),params,null);
	    
	    if(lista.size()>0){	    
	    	return lista.get(0).toString().toUpperCase();
	    }else{
	    	return "";	    	
	    }
		
	}
	
	public String obtenerTerritorio(String provincia) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
//		String m="";
		String p="";
		List params = new ArrayList();
		
	    strSql.append("SELECT ");
	    strSql.append(W83bArbitrosBD.descTablaTerritorio).append(" AS ").append(W83bListadosBD.descmunicipio);
	    strSql.append(" FROM ");
	    strSql.append(W83bArbitrosBD.arbitrosProvinciaTable);
	    strSql.append(" WHERE ");
	    strSql.append(W83bArbitrosBD.idTablaTerritorio).append("=?");
	    
	    if (provincia!=null){
	    	  if (provincia.length()==1){
	  	    	p="0"+provincia;
	  	    }
	  	    else{
	  	    	p=provincia;
	  	    }
	    }
	   
	    params.add(p);
		
	    List lista = W83bDataBase.executeSimpleQuerySinTrazas(strSql.toString(),params,null);
	    
	    if(lista.size()>0){	    
	    	return lista.get(0).toString().toUpperCase();
	    }else{
	    	return "";	    	
	    }
		
	}
	
	public List buscarActaNueva(W83bActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.numActa).append(",");
		strSql.append(W83bActasBD.numTotalActa).append(",");
		strSql.append(W83bActasBD.numRegDefinitivo).append(",");
		strSql.append(W83bActasBD.fechaBaja).append(",");
		strSql.append(W83bActasBD.codCentro).append(",");
		strSql.append(W83bActasBD.validada).append(",");
		strSql.append(W83bActasBD.versionActa);
		strSql.append(" FROM ");
		strSql.append(W83bActasBD.actasTable).append(" WHERE ");
		strSql.append(W83bActasBD.numActa).append("=? AND ");
		strSql.append(W83bActasBD.anyoActa).append("=? AND ");
		strSql.append(W83bActasBD.codTerritActa).append("=?");
		strSql.append(" ORDER BY ");
		strSql.append(W83bActasBD.versionActa);
		strSql.append(" DESC ");
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		return W83bDataBase.executeQuery(strSql.toString(),params,null);
		
		
	}
	public List buscarActaNuevaDatosCentro(W83bActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.numActa).append(",");
		strSql.append(W83bActasBD.numTotalActa).append(",");
		strSql.append(W83bActasBD.numRegDefinitivo).append(",");
		strSql.append(W83bActasBD.fechaBaja).append(",");
		strSql.append(W83bActasBD.codCentro).append(",");
		strSql.append(W83bActasBD.validada).append(",");
		strSql.append(W83bActasBD.versionActa).append(",");
		strSql.append(W83bCentroTrabajoBD.codigoCentro).append(", ");
		strSql.append(W83bCentroTrabajoBD.codNifCif).append(", ");
		strSql.append(W83bCentroTrabajoBD.ncentroTrab).append(", ");
		strSql.append(W83bCentroTrabajoBD.razonSocial).append(", ");
		strSql.append(W83bCentroTrabajoBD.codProvinciaCentro).append(", ");
		strSql.append(W83bCentroTrabajoBD.codMunicipioCentro).append(", ");
		strSql.append(W83bCentroTrabajoBD.nTrabHombres).append(", ");
		strSql.append(W83bCentroTrabajoBD.nTrabMujeres).append(", ");
		strSql.append(W83bCentroTrabajoBD.nTrabajadores);
		strSql.append(" FROM ");
		strSql.append(W83bActasBD.actasTable).append(", ");
		strSql.append(W83bCentroTrabajoBD.J7301S00);
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.codCentro).append("=");
		strSql.append(W83bCentroTrabajoBD.codigoCentro).append(" AND ");
		strSql.append(W83bActasBD.numActa).append("=? AND ");
		strSql.append(W83bActasBD.anyoActa).append("=? AND ");
		strSql.append(W83bActasBD.codTerritActa).append("=?");
		strSql.append(" ORDER BY ");
		strSql.append(W83bActasBD.versionActa);
		strSql.append(" DESC ");
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		return W83bDataBase.executeQuery(strSql.toString(),params,null);
		
		
	}
	public List buscarActaMaxVersionValidada(W83bActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT MAX(");
		strSql.append(W83bActasBD.versionActa);
		strSql.append(") as ");
		strSql.append(W83bActasBD.versionActa);
		strSql.append(" FROM ");
		strSql.append(W83bActasBD.actasTable).append(" WHERE ");
		strSql.append(W83bActasBD.numActa).append("=? AND ");
		strSql.append(W83bActasBD.anyoActa).append("=? AND ");
		strSql.append(W83bActasBD.codTerritActa).append("=? and ");
		strSql.append(W83bActasBD.validada).append("= 1");
		strSql.append(" ORDER BY ");
		strSql.append(W83bActasBD.versionActa);
		strSql.append(" DESC ");
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		return W83bDataBase.executeQuery(strSql.toString(),params,null);
		
		
	}
	
	public List buscarActaMaxVersionValidadaNoValidada(W83bActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT MAX(");
		strSql.append(W83bActasBD.versionActa);
		strSql.append(") as ");
		strSql.append(W83bActasBD.versionActa);
		strSql.append(" FROM ");
		strSql.append(W83bActasBD.actasTable).append(" WHERE ");
		strSql.append(W83bActasBD.numActa).append("=? AND ");
		strSql.append(W83bActasBD.anyoActa).append("=? AND ");
		strSql.append(W83bActasBD.codTerritActa).append("=? and (");
		strSql.append(W83bActasBD.validada).append("= 1 or ");
		strSql.append(W83bActasBD.validada).append("= 0)");
		strSql.append(" ORDER BY ");
		strSql.append(W83bActasBD.versionActa);
		strSql.append(" DESC ");
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		return W83bDataBase.executeQuery(strSql.toString(),params,null);
		
		
	}
	public W83bConveniosBean buscarConvenio(w83b.w83bBeans.W83bActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bConveniosBD.tipoEmpresa).append(", ");
		strSql.append(W83bConveniosBD.espEnAlava).append(", ");
		strSql.append(W83bConveniosBD.espEnBizkaia).append(", ");
		strSql.append(W83bConveniosBD.espEnGuip).append(", ");
		strSql.append(W83bConveniosBD.descripcion).append(", ");
		strSql.append(W83bConveniosBD.descripcion_eusk).append(", ");
		strSql.append(W83bConveniosBD.convPorEscrut).append(", ");
		strSql.append(W83bConveniosBD.baja);
		strSql.append(" FROM ").append(W83bConveniosBD.convenioTable);
		strSql.append(" WHERE ").append(W83bConveniosBD.codigo).append(" = ?");
		params.add(param.getCodConvenio());
		
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bConveniosBean.class,null, param.getIdioma());
		
		return (W83bConveniosBean)listaActas.get(0);	
	}
	public W83bDatosEscrutiniosBean buscarDelegados(w83b.w83bBeans.W83bActasBean param) throws Exception{
		W83bDatosEscrutiniosBean escrutinio=new W83bDatosEscrutiniosBean();
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(param.getUsuarioBean().getIdUsuario());
		
	    
		strSql.append("SELECT ");
		strSql.append(W83bNumDelegadosBD.numDelegados);
		strSql.append(" FROM ").append(W83bNumDelegadosBD.convenioTable);
		strSql.append(" WHERE ? BETWEEN ").append(W83bNumDelegadosBD.trabDesde).append(" AND ");
		strSql.append(W83bNumDelegadosBD.trabHasta).append(" AND ");
		strSql.append(W83bNumDelegadosBD.tipoConvenio).append(" = ?");
		params.add(param.getTrabajadoresTotal());
		if(param.getCodConvenio().substring(0, 1).equals("9"))
			params.add(W83bClsConstantes.CONVENIO_ADMINISTRACION);
		else
			params.add(W83bClsConstantes.CONVENIO_OTRO);
		
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,param.getUsuarioBean());
		if(listaActas.size()==0){
			escrutinio.setElectoresTotalColegioC1("0");
			escrutinio.setElectoresTotalColegioC2("0");
		}
		else{
			escrutinio.setElectoresTotalColegioC1(((BigDecimal)listaActas.get(0)).toString());
			escrutinio.setElectoresTotalColegioC2(((BigDecimal)listaActas.get(0)).toString());
		}
		//TERMINAR USUARIO
		W83bDataBase.terminarUsuarioAuditor();
		
		return escrutinio;	
	}
	public java.util.List cargarCentroTrabajo(HashMap mapaResultado) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bCentroTrabajoVistaBD.cifnif);
		strSql.append(" || '_' ||");
		strSql.append(W83bCentroTrabajoVistaBD.nCentro);
		strSql.append(" || '_' ||");
		strSql.append(W83bCentroTrabajoVistaBD.codMunicipio);
		strSql.append(" || '_' ||");
		strSql.append(W83bCentroTrabajoVistaBD.codTerritorio);
		strSql.append(" AS codigo, ");
		strSql.append(W83bCentroTrabajoVistaBD.razonsocial);
		strSql.append(" as descripcion ");
		strSql.append(" FROM ");
		strSql.append(W83bCentroTrabajoVistaBD.nombreVista);
		strSql.append(" WHERE UPPER(");
		strSql.append(W83bCentroTrabajoVistaBD.razonsocial);
		strSql.append(") LIKE UPPER(?)");
		params.add(new StringBuffer(W83bClsConstantes.CUARENTA).append(mapaResultado.get("q"))
				.append("%").toString());
		if(StringUtils.isNotEmpty((String)mapaResultado.get("limit"))){
			strSql.append(" and ROWNUM <= ? ");
			params.add((String)mapaResultado.get("limit"));
		}
		
		List listaDatosParametros = W83bDataBase.executeQuery(strSql.toString(),params,null);
		
		return listaDatosParametros;
	}
	public String insertarDiferencia(W83bListaDiferenciasBean diferencia,String acta, String anyoActa,String territorioActa,String versionActa,String usuario,String idioma) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("INSERT INTO ").append(W83bDiferenciasBD.difTable);
		strSql.append("(").append(W83bDiferenciasBD.acta).append(",");
		strSql.append(W83bDiferenciasBD.anyoActa).append(",");
		strSql.append(W83bDiferenciasBD.territorioActa).append(",");
		strSql.append(W83bDiferenciasBD.versionActa).append(",");
		strSql.append(W83bDiferenciasBD.codSind).append(",");
		strSql.append(W83bDiferenciasBD.codigoColegio).append(",");
		strSql.append(W83bDiferenciasBD.delegadosHombres).append(",");
		strSql.append(W83bDiferenciasBD.delegadosMujeres).append(",");
		strSql.append(W83bDiferenciasBD.usuario).append(",");
		strSql.append(W83bDiferenciasBD.fecha).append(") VALUES (?,?,?,?,?,?,?,?,?,to_Date(?,?))");
		params.add(acta);
		params.add(anyoActa);
		params.add(territorioActa);
		params.add(versionActa);
		params.add(diferencia.getSindicato());
		params.add(diferencia.getCodColegio());
		params.add(diferencia.getHombres());
		params.add(diferencia.getMujeres());
		params.add(usuario);
		
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
		params.add(sdf.format(new Date()));
		params.add(W83bDateUtil.ES_PATTERN);
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,diferencia.getUsuarioBean());
		
		return "0";	
	}
	public String insertarEscrutinio(W83bListaEscrutiniosBean escrutinio,String acta, String anyoActa,String territorioActa,String versionActa,String usuario,String idioma) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("INSERT INTO ").append(W83bEscrutiniosBD.escrutTable);
		strSql.append("(").append(W83bEscrutiniosBD.acta).append(",");
		strSql.append(W83bEscrutiniosBD.anyoActa).append(",");
		strSql.append(W83bEscrutiniosBD.territorioActa).append(",");
		strSql.append(W83bEscrutiniosBD.versionActa).append(",");
		strSql.append(W83bEscrutiniosBD.codSind).append(",");
		strSql.append(W83bEscrutiniosBD.codigoColegio).append(",");
		strSql.append(W83bEscrutiniosBD.delegadosHombres).append(",");
		strSql.append(W83bEscrutiniosBD.delegadosMujeres).append(",");
		strSql.append(W83bEscrutiniosBD.numVotos).append(",");
		strSql.append(W83bEscrutiniosBD.usuario).append(",");
		strSql.append(W83bEscrutiniosBD.fecha).append(") VALUES (?,?,?,?,?,?,?,?,?,?,to_Date(?,?))");
		params.add(acta);
		params.add(anyoActa);
		params.add(territorioActa);
		params.add(versionActa);
		params.add(escrutinio.getSindicato());
		params.add(escrutinio.getCodColegio());
		params.add(escrutinio.getHombres());
		params.add(escrutinio.getMujeres());
		params.add(escrutinio.getNumVotos());
		params.add(usuario);
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
		params.add(sdf.format(new Date()));
		params.add(W83bDateUtil.ES_PATTERN);
		W83bDataBase.executeTableMovement(strSql.toString(), params,escrutinio.getUsuarioBean());
		
		return "0";	
	}
	public String insertarDelegado(W83bListaDelegadosBean delegado,String acta, String anyoActa,String territorioActa,String versionActa,String usuario,String idioma) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(usuario);
		
		List params = new ArrayList();
		strSql.append("INSERT INTO ").append(W83bDelegadosBD.delegadosTable);
		strSql.append("(").append(W83bDelegadosBD.acta).append(",");
		strSql.append(W83bDelegadosBD.anyoActa).append(",");
		strSql.append(W83bDelegadosBD.territorioActa).append(",");
		strSql.append(W83bDelegadosBD.versionActa).append(",");
		strSql.append(W83bDelegadosBD.codSindicato).append(",");
		strSql.append(W83bDelegadosBD.codColegio).append(",");
		strSql.append(W83bDelegadosBD.dni).append(",");
		strSql.append(W83bDelegadosBD.nombre).append(",");
		strSql.append(W83bDelegadosBD.apellido1).append(",");
		strSql.append(W83bDelegadosBD.apellido2).append(",");
		strSql.append(W83bDelegadosBD.sexo).append(",");
		strSql.append(W83bDelegadosBD.dniSustituto).append(",");//12
		strSql.append(W83bDelegadosBD.fechaBaja).append(",");
		strSql.append(W83bDelegadosBD.baja).append(",");
		strSql.append(W83bDelegadosBD.usuario).append(",");
		strSql.append(W83bDelegadosBD.fechaMod).append(",");
		strSql.append(W83bDelegadosBD.fechaAlta).append(") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,to_Date(?,?),?,?,to_Date(?,?),to_Date(?,?))");
		params.add(acta);
		params.add(anyoActa);
		params.add(territorioActa);
		params.add(versionActa);
		params.add(delegado.getCodSindicato());
		params.add(delegado.getCodColegio());
		params.add(delegado.getDni());
		params.add(delegado.getNombre());
		params.add(delegado.getApellido1());
		params.add(delegado.getApellido2());
		params.add(delegado.getSexo());
		
		if(StringUtils.isNotEmpty(delegado.getDniSustituto())){
			params.add(delegado.getDniSustituto());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);
		}
		if(StringUtils.isNotEmpty(delegado.getFechaBaja())){
			params.add(delegado.getFechaBaja());
		}
		else{
			params.add(W83bClsConstantes.NULL_DATE);
		}
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		if(StringUtils.isNotEmpty(delegado.getCodBaja())){
			params.add(delegado.getCodBaja());
		}
		else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
	
		params.add(usuario);
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
		if(StringUtils.isEmpty(delegado.getFechaMod())){
			params.add(sdf.format(new Date()));
			params.add(W83bDateUtil.ES_PATTERN);
		}else{
			params.add(delegado.getFechaMod());
			params.add(W83bDateUtil.ES_PATTERN);			
		}
		if(StringUtils.isEmpty(delegado.getFechaAlta())){
			params.add(sdf.format(new Date()));
			params.add(W83bDateUtil.ES_PATTERN);
		}else{
			params.add(delegado.getFechaAlta());
			params.add(W83bDateUtil.ES_PATTERN);			
		}
		W83bDataBase.executeTableMovement(strSql.toString(), params,delegado.getUsuarioBean());
		//TERMINAR USUARIO
		W83bDataBase.terminarUsuarioAuditor();
		return "0";	
	}
	public String insertarActa(W83bActasBean acta,String pantalla) throws Exception{
		String fechaRegistro="";
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		String formato=W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma());
		strSql.append("INSERT INTO ").append(W83bActasBD.actasTable);
		strSql.append("(").append(W83bActasBD.numActa).append(",");
		strSql.append(W83bActasBD.anyoActa).append(",");
		strSql.append(W83bActasBD.versionActa).append(",");
		strSql.append(W83bActasBD.codTerritActa).append(",");
		strSql.append(W83bActasBD.numPreaviso).append(",");
		strSql.append(W83bActasBD.anyoPreaviso).append(",");
		strSql.append(W83bActasBD.codConvenio).append(",");
		strSql.append(W83bActasBD.codCentro).append(",");
		strSql.append(W83bActasBD.codMotivosBaja).append(",");
		strSql.append(W83bActasBD.fechaEntrada).append(",");//10
		strSql.append(W83bActasBD.fechaEleccion).append(",");
		
		strSql.append(W83bActasBD.totalElectores).append(",");
		strSql.append(W83bActasBD.nCandidatosHombre).append(",");
		strSql.append(W83bActasBD.nCandidatosMujer).append(",");
		strSql.append(W83bActasBD.anyoTotalActa).append(",");
		strSql.append(W83bActasBD.numTotalActa).append(",");
		strSql.append(W83bActasBD.numRegistro).append(",");
		strSql.append(W83bActasBD.fechaRegistro).append(",");
		strSql.append(W83bActasBD.anyoRegDefinitivo).append(",");

		strSql.append(W83bActasBD.fechaComision).append(",");

		strSql.append(W83bActasBD.fechaBaja).append(",");
	
		strSql.append(W83bActasBD.nElectoresHombre).append(",");
		strSql.append(W83bActasBD.nElectoresMujer).append(",");
		strSql.append(W83bActasBD.totaldel).append(",");
		strSql.append(W83bActasBD.delHombres).append(",");
		strSql.append(W83bActasBD.delMujeres).append(",");
		strSql.append(W83bActasBD.marcaComision).append(",");
		strSql.append(W83bActasBD.observaciones).append(",");
		strSql.append(W83bActasBD.usuarioActualizacion).append(",");
		strSql.append(W83bActasBD.fechaActualizacion).append(",");
		strSql.append(W83bActasBD.inspeccionada).append(",");//30
		strSql.append(W83bActasBD.maxDel).append(",");
		strSql.append(W83bActasBD.F_CONSTCOM_016).append(",");
		strSql.append(W83bActasBD.REMITE_016).append(",");
		strSql.append(W83bActasBD.validada);
		if("incidencias".equals(pantalla)){
			strSql.append(",").append(W83bActasBD.nueva);
		}
		strSql.append(") VALUES (?,?,?,?,?,?,?,?,?,to_Date(?,?),to_Date(?,?),?,?,?,?,?,?,to_Date(?,?),?,");

		strSql.append("to_Date(?,?),to_Date(?,?),?,?,?,?,?,?,?,?,to_Date(?,?),?,?,to_Date(?,?),?,?");
		if("incidencias".equals(pantalla)){
			strSql.append(",?");
		}
		strSql.append(")");
		params.add(acta.getNumActa());
		params.add(acta.getNumActaAno());
		params.add(acta.getVersion());
		params.add(acta.getNumActaTerritorio());
		if(StringUtils.isNotEmpty(acta.getNumPreaviso())){
			params.add(acta.getNumPreaviso());
		}
		else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		if(StringUtils.isNotEmpty(acta.getAnyoPreaviso())){
			params.add(acta.getAnyoPreaviso());
		}
		else{
			params.add(W83bClsConstantes.NULL_INTEGER);
		}
		params.add(acta.getCodConvenio());
		params.add(acta.getCodCentroTrabajo());
		if(StringUtils.isNotEmpty(acta.getMotivoBaja())){
			params.add(acta.getMotivoBaja());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		params.add(acta.getFechaEntrada());//10
		params.add(formato);
		params.add(acta.getFechaEleccion());
		params.add(formato);
		params.add(acta.getElectoresTotal());
		params.add(acta.getCandidatosHombres());
		params.add(acta.getCandidatosMujeres());
		if(StringUtils.isNotEmpty(acta.getAnyoActaTotal())){
			params.add(acta.getAnyoActaTotal());
		}
		else{
			params.add(W83bClsConstantes.NULL_INTEGER);			
		}
		if(StringUtils.isNotEmpty(acta.getNumActaTotal())){
			params.add(acta.getNumActaTotal());
		}
		else{
			params.add(W83bClsConstantes.NULL_INTEGER);			
		}
		if(StringUtils.isNotEmpty(acta.getNumRegistroES())){
			params.add(acta.getNumRegistroES().toUpperCase());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		if(StringUtils.isNotEmpty(acta.getFechaRegistroES())){
			params.add(acta.getFechaRegistroES());//20
			params.add(formato);
			fechaRegistro=acta.getFechaRegistroES();
		}
		else{
			params.add(W83bClsConstantes.NULL_DATE);	//20
			params.add(formato);
		}
		if(StringUtils.isNotEmpty(acta.getNumRegAnyo())){
			params.add(acta.getNumRegAnyo());
		}
		else{
			params.add(W83bClsConstantes.NULL_INTEGER);			
		}

		if(StringUtils.isNotEmpty(acta.getFechaComision())){
			params.add(acta.getFechaComision());
			params.add(formato);
		}
		else{
			params.add(W83bClsConstantes.NULL_DATE);	
			params.add(formato);
		}
	
		if(StringUtils.isNotEmpty(acta.getFechaBaja())){
			params.add(acta.getFechaBaja());
			params.add(formato);
		}
		else{
			params.add(W83bClsConstantes.NULL_DATE);
			params.add(formato);
		}
		
		params.add(acta.getElectoresHombres());
		params.add(acta.getElectoresMujeres());
		if(StringUtils.isNotEmpty(acta.getDelegadosTotal())){
			params.add(acta.getDelegadosTotal());//32
		}
		else{
			params.add("0");			
		}
		if(StringUtils.isNotEmpty(acta.getDelegadosHombres())){
			params.add(acta.getDelegadosHombres());
		}
		else{
			params.add("0");			
		}
		if(StringUtils.isNotEmpty(acta.getDelegadosMujeres())){
			params.add(acta.getDelegadosMujeres());
		}
		else{
			params.add("0");			
		}
		
		if(StringUtils.isNotEmpty(acta.getComision())){
			params.add(acta.getComision());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		if(StringUtils.isNotEmpty(acta.getObservaciones())){
			params.add(acta.getObservaciones().toUpperCase());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		if(StringUtils.isNotEmpty(acta.getUsuarioBean().getIdUsuario())){
			params.add(acta.getUsuarioBean().getIdUsuario());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		/*SimpleDateFormat sdf =new SimpleDateFormat(formato);
		params.add(sdf.format(new Date()));//30
		params.add(formato);*/
		params.add(acta.getFechaEleccion());
		params.add(formato);
		if(StringUtils.isNotEmpty(acta.getInspeccionada())){
			params.add(acta.getInspeccionada());
		}
		else{
			params.add(W83bClsConstantes.NULL_INTEGER);			
		}
		params.add(acta.getDelegadosMaximo());
		params.add(W83bClsConstantes.NULL_DATE);
		params.add(formato);
		if(StringUtils.isNotEmpty(acta.getRemitente())){
			params.add(acta.getRemitente().toUpperCase());
		}else{
			params.add(W83bClsConstantes.NULL_STRING);	
		}
		if(StringUtils.isNotEmpty(acta.getValidada())){
			params.add(acta.getValidada());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
		if("incidencias".equals(pantalla)){
			if(StringUtils.isNotEmpty(acta.getNueva())){
				params.add(acta.getNueva());
			}
			else{
				params.add("0");			
			}
		}
		W83bDataBase.executeTableMovement(strSql.toString(), params,acta.getUsuarioBean());
//		W83bClsTrazas.trazaError(null, "strSql "+strSql, null);
//		W83bClsTrazas.trazaError(null, "params "+params, null);
//		W83bClsTrazas.trazaError(null, "fechaRegistro "+fechaRegistro, null);
//		W83bClsTrazas.trazaError(null, "acta.getUsuarioBean().getRegManual() "+acta.getUsuarioBean().getRegManual(), null);
		//libro de registro
		
		if (StringUtils.isEmpty(acta.getFechaRegistroES())
				&&"0".equals(acta.getUsuarioBean().getRegManual())
				&&!"incidencias".equals(pantalla)){
//			W83bClsTrazas.trazaError(null, "entro", null);
			try{
			//Libro Registro
			 String observaciones="Acta n: "+acta.getNumActaTerritorio()+"/"+acta.getNumActaAno()+"/"+acta.getNumActa();//NOPMD
			 String empresa=acta.getRemitente();
			 if(StringUtils.isEmpty(empresa)){
				 empresa = acta.getCentroTrabajo().getCifnif();
			 }
				W83bClsTrazas.trazaError(null, "acta.getUsuarioBean().getRegManual() "+acta.getUsuarioBean().getRegManual(), null);	
			W83bClsTrazas.trazaError(null, "acta.getUsuarioBean().getModelo() "+acta.getUsuarioBean().getModelo(), null);	
			W83bClsTrazas.trazaError(null, "empresa "+empresa, null);	
			W83bClsTrazas.trazaError(null, "acta.getNumActaTerritorio() "+acta.getNumActaTerritorio(), null);	
			W83bClsTrazas.trazaError(null, "observaciones "+observaciones, null);	
			W83bClsTrazas.trazaError(null, "acta.getUsuarioBean() "+acta.getUsuarioBean(), null);	
			W83bClsTrazas.trazaError(null, "acta.getUsuarioBean().getRegManual() "+acta.getUsuarioBean().getRegManual(), null);	
			W83bClsTrazas.trazaError(null, "acta.getUsuarioBean().getModelo() "+acta.getUsuarioBean().getModelo(), null);	
			W83bClsTrazas.trazaError(null, "empresa "+empresa, null);	
			W83bClsTrazas.trazaError(null, "acta.getNumActaTerritorio() "+acta.getNumActaTerritorio(), null);	
			W83bClsTrazas.trazaError(null, "observaciones "+observaciones, null);	
			W83bClsTrazas.trazaError(null, "acta.getUsuarioBean() "+acta.getUsuarioBean(), null);	
			String[] resul= new String[2];
				
				resul = W83bLibroRegistro.getAltaRegistro(true, acta.getUsuarioBean().getModelo(), "E", "E", empresa, acta.getNumActaTerritorio(), "", observaciones, acta.getUsuarioBean());
				W83bClsTrazas.trazaError(null, "resul "+resul, null);
			//Fin Libro Registro
			strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			params = new ArrayList();
			 
			strSql.append("UPDATE ") ;
			strSql.append(W83bActasBD.actasTable);
			strSql.append(" SET ");
			strSql.append(W83bActasBD.fechaRegistro);
			strSql.append(" = to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO+"')");
			strSql.append(",");
			strSql.append(W83bActasBD.numRegistro);
			strSql.append(" = ?");
			strSql.append(" WHERE ").append(W83bActasBD.codTerritActa).append(" = ? ");
			strSql.append(" AND ").append(W83bActasBD.anyoActa).append(" = ? ");
			strSql.append(" AND ").append(W83bActasBD.numActa).append(" = ? ");
			
			params.add(resul[1]);
			params.add(resul[0]);
			acta.setFechaRegistroES(resul[1]);
			acta.setNumRegistroES(resul[0]);
//			if(StringUtils.isNotEmpty(acta.getFechaRegistroES())){
//				params.add(acta.getFechaRegistroES());
//			}
//			else{
//				params.add(W83bClsConstantes.NULL_DATE);			
//			}
//			if(StringUtils.isNotEmpty(acta.getNumRegistroES())){
//				params.add(acta.getNumRegistroES().toUpperCase());
//			}
//			else{
//				params.add(W83bClsConstantes.NULL_STRING);			
//			}
//			params.add(acta.getFechaRegistroES());
//			params.add(acta.getNumRegistroES());
			params.add(acta.getNumActaTerritorio());
			params.add(acta.getNumActaAno());
			params.add(acta.getNumActa());
			
//			W83bClsTrazas.trazaError(null, "strSql "+strSql.toString(), null);
			
			W83bDataBase.executeTableMovement(strSql.toString(), params,acta.getUsuarioBean());
			fechaRegistro=acta.getFechaRegistroES();
			}catch(W83bLibroRegistroException e){
				fechaRegistro = "error";
//				W83bClsTrazas.trazaError(null, "ERROR!!! ", null);
			}
		}
		return fechaRegistro;
	}
	public java.util.List cargarColegios() throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bColegiosBD.cod);
		strSql.append(" ,");
		strSql.append(W83bColegiosBD.descripcion);
		strSql.append(" ,");
		strSql.append(W83bColegiosBD.descripcion_eu);
		strSql.append(" FROM ");
		strSql.append(W83bColegiosBD.colegiosTable);
		strSql.append(" ORDER BY ");
		strSql.append(W83bColegiosBD.cod);
		List listaDatosParametros = W83bDataBase.executeQuery(strSql.toString(),params,null);
		
		return listaDatosParametros;
	}
	public java.util.List buscarPreavisos(W83bActasBean acta) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bPreavisosBD.c_territ_037).append("||'/'||");
		strSql.append(W83bPreavisosBD.ano_acta_037).append("||'/'||");
		strSql.append(W83bPreavisosBD.n_acta_037).append(" AS ACTA,");
		strSql.append(W83bCentroTrabajoBD.codigoCentro).append(", ");
		strSql.append(W83bCentroTrabajoBD.codNifCif).append(", ");
		strSql.append(W83bCentroTrabajoBD.ncentroTrab).append(", ");
		strSql.append(W83bCentroTrabajoBD.razonSocial).append(", ");
		strSql.append(W83bCentroTrabajoBD.codProvinciaCentro).append(", ");
		strSql.append(W83bCentroTrabajoBD.codMunicipioCentro).append(", ");
		strSql.append(W83bCentroTrabajoBD.nTrabHombres).append(", ");
		strSql.append(W83bCentroTrabajoBD.nTrabMujeres).append(", ");
		strSql.append(W83bPreavisosBD.s_parcial_037).append(", ");
		strSql.append(W83bCentroTrabajoBD.nTrabajadores).append(", ");
		strSql.append(W83bCentroTrabajoBD.codigoConvenio);
		strSql.append(" FROM ");
		strSql.append(W83bPreavisosBD.preavisosTable).append(", ");
		strSql.append(W83bCentroTrabajoBD.J7301S00);
		strSql.append(" WHERE ");
		strSql.append(W83bPreavisosBD.id_centro_037).append("=");
		strSql.append(W83bCentroTrabajoBD.codigoCentro).append(" AND ");
		strSql.append(W83bPreavisosBD.ano_preaviso_037).append("=? AND ");
		strSql.append(W83bPreavisosBD.c_territ_037).append("=? AND ");
		strSql.append(W83bPreavisosBD.n_preaviso_037).append("=?");
		params.add(acta.getAnyoPreaviso());
		params.add(acta.getTerritorioPreaviso());
		params.add(acta.getNumPreaviso());
		List listaDatosParametros = W83bDataBase.executeQuery(strSql.toString(),params,null);
		
		return listaDatosParametros;
	}
/*
	 * MODIFICADO POR ANA 07-11-2013
	 * (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIActasDAO#buscarPreavisos(w83b.w83bBeans.W83bActasBean)
	 */
		
		public java.util.List buscarActaTotal(W83bActasBean acta) throws Exception{
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			
			strSql.append("SELECT ");
			strSql.append(W83bActasBD.codTerritActa).append("||'/'||");
			strSql.append(W83bActasBD.anyoActa).append("||'/'||");
			strSql.append(W83bActasBD.numActa).append(" AS ACTA_16");
			strSql.append(" FROM ");
			strSql.append(W83bPreavisosBD.preavisosTable).append(", ");
			strSql.append(W83bCentroTrabajoBD.J7301S00).append(", ");
			strSql.append(W83bActasBD.actasTable).append(" tact");
			strSql.append(" WHERE ");
			strSql.append(W83bPreavisosBD.id_centro_037).append("=");
			strSql.append(W83bCentroTrabajoBD.codigoCentro).append(" AND ");
			strSql.append(W83bActasBD.codCentro).append("=");
			strSql.append(W83bCentroTrabajoBD.codigoCentro).append(" AND ");
			strSql.append(W83bPreavisosBD.ano_preaviso_037).append("=? AND ");
			strSql.append(W83bPreavisosBD.c_territ_037).append("=? AND ");
			strSql.append(W83bPreavisosBD.n_preaviso_037).append("=? AND ((");
			strSql.append(W83bActasBD.fechaEleccion).append("+ numtoyminterval(4, 'YEAR'))- sysdate) >0 AND ");
			strSql.append(W83bActasBD.versionActa).append("= (SELECT MAX (").append(W83bActasBD.versionActa);
			strSql.append(") FROM ");
			strSql.append(W83bActasBD.actasTable).append(" act");
			strSql.append(" WHERE ");
			strSql.append("tact.").append(W83bActasBD.numActa).append("=act.").append(W83bActasBD.numActa).append(" AND ");
			strSql.append("tact.").append(W83bActasBD.anyoActa).append("=act.").append(W83bActasBD.anyoActa).append(" AND ");
			strSql.append("tact.").append(W83bActasBD.codTerritActa).append("=act.").append(W83bActasBD.codTerritActa).append(" AND ");
			strSql.append("act.").append(W83bActasBD.validada).append("=1)");
			
			params.add(acta.getAnyoPreaviso());
			params.add(acta.getTerritorioPreaviso());
			params.add(acta.getNumPreaviso());
			List listaDatosParametros = W83bDataBase.executeQuery(strSql.toString(),params,null);
			
			return listaDatosParametros;
		}
	public java.util.HashMap buscarEscrutinio(w83b.w83bBeans.W83bActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bEscrutiniosBD.codSind).append(",");
		strSql.append(W83bEscrutiniosBD.codigoColegio).append(",");
		strSql.append(W83bEscrutiniosBD.delegadosHombres).append(",");
		strSql.append(W83bEscrutiniosBD.delegadosMujeres).append(",");
		strSql.append(W83bEscrutiniosBD.numVotos).append(",");
		if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83bSindicatosBD.descSindicatoCast).append(" as DESCRIPCION");
		}
		else{
			strSql.append(W83bSindicatosBD.descSindicatoEusk).append(" as DESCRIPCION");
		}
		
	
		strSql.append(" FROM ").append(W83bEscrutiniosBD.escrutTable).append(" ESCR, ");
		strSql.append(W83bSindicatosBD.sindicatosTable).append(" SIND ");
		strSql.append(" WHERE ESCR.").append(W83bEscrutiniosBD.codSind).append(" = ");
		strSql.append(W83bSindicatosBD.codSindicato);
		strSql.append(" AND ESCR.").append(W83bEscrutiniosBD.acta).append(" = ? AND ");
		strSql.append(" ESCR.").append(W83bEscrutiniosBD.anyoActa).append(" = ? AND ");
		strSql.append(" ESCR.").append(W83bEscrutiniosBD.territorioActa).append(" = ? AND ");
		strSql.append(" ESCR.").append(W83bEscrutiniosBD.versionActa).append(" = ? AND ");
		strSql.append(" ESCR.").append(W83bEscrutiniosBD.codigoColegio).append(" = ?  ");
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		params.add(param.getVersion());
		if(param.getModo().equals("C1")){
			params.add(param.getColegios().getCod1());
		}
		else{
			params.add(param.getColegios().getCod2());
		}
		HashMap listaEscrutinios=W83bDataBase.executeQueryHashMap(strSql.toString(),params, W83bListaEscrutiniosBean.class, param.getUsuarioBean(), "DETALLE","sindicato");
		
		return listaEscrutinios;	
	}

	public java.util.HashMap buscarEscrutinioColegios(w83b.w83bBeans.W83bActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ").append(W83bEscrutiniosBD.codSind).append(",");
		strSql.append(W83bEscrutiniosBD.codigoColegio).append(",").append(W83bEscrutiniosBD.delegadosHombres).append(",");
		strSql.append(W83bEscrutiniosBD.delegadosMujeres).append(",").append(W83bEscrutiniosBD.numVotos).append(",");
		if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83bSindicatosBD.descSindicatoCast).append(" as DESCRIPCION");
		}
		else{
			strSql.append(W83bSindicatosBD.descSindicatoEusk).append(" as DESCRIPCION");
		}
		strSql.append(" FROM ").append(W83bEscrutiniosBD.escrutTable).append(" ESCR, ").append(W83bSindicatosBD.sindicatosTable).append(" SIND ");
		strSql.append(" WHERE ESCR.").append(W83bEscrutiniosBD.codSind).append(" = ").append(W83bSindicatosBD.codSindicato);
		strSql.append(" AND ESCR.").append(W83bEscrutiniosBD.acta).append(" = ? AND ");
		strSql.append(" ESCR.").append(W83bEscrutiniosBD.anyoActa).append(" = ? AND ");
		strSql.append(" ESCR.").append(W83bEscrutiniosBD.territorioActa).append(" = ? AND ");
		strSql.append(" ESCR.").append(W83bEscrutiniosBD.versionActa).append(" = ? ");
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		params.add(param.getVersion());
		HashMap listaEscrutinios=W83bDataBase.executeQueryHashMap(strSql.toString(),params, W83bListaEscrutiniosBean.class, param.getUsuarioBean(), "DETALLE","sindicatoColegio");
		
		return listaEscrutinios;	
	}
	public java.util.HashMap delegados(w83b.w83bBeans.W83bActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append("SUM(").append( W83bEscrutiniosBD.delegadosHombres).append(") AS HOMBRES,");
		strSql.append("SUM(").append( W83bEscrutiniosBD.delegadosMujeres).append(") AS MUJERES ");
		strSql.append(" FROM ").append(W83bEscrutiniosBD.escrutTable);
		strSql.append(" WHERE ");
		strSql.append(W83bEscrutiniosBD.acta).append(" = ? AND ");
		strSql.append(W83bEscrutiniosBD.anyoActa).append(" = ? AND ");
		strSql.append(W83bEscrutiniosBD.territorioActa).append(" = ? AND ");
		strSql.append(W83bEscrutiniosBD.versionActa).append(" = ? AND ");
		strSql.append(W83bEscrutiniosBD.codigoColegio).append(" = ?  ");
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		params.add(param.getVersion());
		if(param.getModo().equals("C1")){
			params.add(param.getColegios().getCod1());
		}
		else{
			params.add(param.getColegios().getCod2());
		}
		HashMap listaEscrutinios=W83bDataBase.executeQueryHashMap(strSql.toString(),params, W83bListaEscrutiniosBean.class, param.getUsuarioBean(), "DETALLE","sindicato");
		
		return listaEscrutinios;	
	}
	public java.util.HashMap buscarDiferencia(w83b.w83bBeans.W83bActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ").append(W83bDiferenciasBD.codSind).append(",");
		strSql.append(W83bDiferenciasBD.codigoColegio).append(",").append(W83bDiferenciasBD.delegadosHombres).append(",");
		strSql.append(W83bDiferenciasBD.delegadosMujeres).append(",");
		if(param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83bSindicatosBD.descSindicatoCast).append(" AS DESCRIPCION");
		}
		else{
			strSql.append(W83bSindicatosBD.descSindicatoEusk).append(" AS DESCRIPCION");
		}
		strSql.append(" FROM ").append(W83bDiferenciasBD.difTable).append(" DIF, ");
		strSql.append(W83bSindicatosBD.sindicatosTable).append(" SIND ");
		strSql.append(" WHERE DIF.").append(W83bDiferenciasBD.codSind).append(" = ").append(W83bSindicatosBD.codSindicato);
		strSql.append(" AND DIF.").append(W83bDiferenciasBD.acta).append(" = ? AND ");
		strSql.append(" DIF.").append(W83bDiferenciasBD.anyoActa).append(" = ? AND ");
		strSql.append(" DIF.").append(W83bDiferenciasBD.territorioActa).append(" = ? AND ");
		strSql.append(" DIF.").append(W83bDiferenciasBD.versionActa).append(" = ? AND ");
		strSql.append(" DIF.").append(W83bDiferenciasBD.codigoColegio).append(" = ? ");
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		params.add(param.getVersion());
		if(param.getModo().equals("C1")){
			params.add(param.getColegios().getCod1());
		}
		else{
			params.add(param.getColegios().getCod2());
		}
		return W83bDataBase.executeQueryHashMap(strSql.toString(),params,W83bListaDiferenciasBean.class,param.getUsuarioBean(), "DETALLE","sindicato");
		
	}
	public java.util.HashMap buscarDiferenciaColegios(w83b.w83bBeans.W83bActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bDiferenciasBD.codSind).append(",");
		strSql.append(W83bDiferenciasBD.codigoColegio).append(",");
		strSql.append(W83bDiferenciasBD.delegadosHombres).append(",");
		strSql.append(W83bDiferenciasBD.delegadosMujeres).append(",");
		if(param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83bSindicatosBD.descSindicatoCast).append(" AS DESCRIPCION");
		}
		else{
			strSql.append(W83bSindicatosBD.descSindicatoEusk).append(" AS DESCRIPCION");
		}
		strSql.append(" FROM ").append(W83bDiferenciasBD.difTable).append(" DIF, ");
		strSql.append(W83bSindicatosBD.sindicatosTable).append(" SIND ");
		strSql.append(" WHERE DIF.").append(W83bDiferenciasBD.codSind).append(" = ");
		strSql.append(W83bSindicatosBD.codSindicato);
		strSql.append(" AND DIF.").append(W83bDiferenciasBD.acta).append(" = ? AND ");
		strSql.append(" DIF.").append(W83bDiferenciasBD.anyoActa).append(" = ? AND ");
		strSql.append(" DIF.").append(W83bDiferenciasBD.territorioActa).append(" = ? AND ");
		strSql.append(" DIF.").append(W83bDiferenciasBD.versionActa).append(" = ? ");
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		params.add(param.getVersion());
		return W83bDataBase.executeQueryHashMap(strSql.toString(),params,W83bListaDiferenciasBean.class,param.getUsuarioBean(), "DETALLE","sindicatoColegio");
		
	}
	public java.util.HashMap buscarListaDelegados(w83b.w83bBeans.W83bActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(param.getUsuarioBean().getIdUsuario());
		
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bDelegadosBD.codColegio).append(",");
		strSql.append(W83bDelegadosBD.dni).append(",");
		strSql.append(W83bDelegadosBD.nombre).append(",");
		strSql.append(W83bDelegadosBD.apellido1).append(",");
		strSql.append(W83bDelegadosBD.apellido2).append(",");
		strSql.append(W83bDelegadosBD.sexo).append(",TO_CHAR(");
		strSql.append(W83bDelegadosBD.fechaAlta).append(",?) F_ALTA_025 ,TO_CHAR(");
		strSql.append(W83bDelegadosBD.fechaBaja).append(",?) F_BAJA_025,");
		strSql.append("CASE WHEN ").append(W83bDelegadosBD.codColegio).append("=0 THEN '")
		.append(W83bClsConstantes.CONSTANTE_DESCRIP_TECNICOS).append("' ELSE '")
		.append(W83bClsConstantes.CONSTANTE_DESCRIP_ESPECIALISTAS).append("' END AS COLEGIO")
		.append(",");
		if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83bSindicatosBD.descSindicatoCast).append(" AS SINDICATO,");
			strSql.append(W83bColegiosBD.descripcion).append(" AS DESCCOLEGIO,");
			strSql.append(W83bMotivosBajaDelegadoBD.descMotivoCast).append(" AS BAJA,");
		}
		else{
			strSql.append(W83bSindicatosBD.descSindicatoEusk).append(" AS SINDICATO,");
			strSql.append(W83bColegiosBD.descripcion_eu).append(" AS DESCCOLEGIO,");
			strSql.append(W83bMotivosBajaDelegadoBD.descMotivoEusk).append(" AS BAJA,");
		}
		strSql.append(W83bSindicatosBD.siglas).append(" AS SIGLAS,");
		strSql.append(W83bDelegadosBD.dniSustituto).append(",");
		strSql.append(W83bDelegadosBD.baja).append(",");
		strSql.append(W83bDelegadosBD.codSindicato);
		strSql.append(" FROM ").append(W83bDelegadosBD.delegadosTable).append(" DEL, ");
		strSql.append(W83bSindicatosBD.sindicatosTable).append(" SIND, ");
		strSql.append(W83bColegiosBD.colegiosTable).append(" COL, ");
		strSql.append(W83bMotivosBajaDelegadoBD.motivosBajaTable).append(" BAJA ");
		strSql.append(" WHERE DEL.").append(W83bDelegadosBD.codSindicato).append(" = SIND.");
		strSql.append(W83bSindicatosBD.codSindicato);
		strSql.append(" AND DEL.").append(W83bDelegadosBD.acta).append(" = ? AND ");
		strSql.append(" DEL.").append(W83bDelegadosBD.anyoActa).append(" = ? AND ");
		strSql.append(" DEL.").append(W83bDelegadosBD.territorioActa).append(" = ? AND ");
		strSql.append(" DEL.").append(W83bDelegadosBD.versionActa).append(" = ? AND ");
		strSql.append(" DEL.").append(W83bDelegadosBD.codColegio).append(" = ");
		strSql.append(" COL.").append(W83bColegiosBD.cod).append(" AND ");
		strSql.append(" DEL.").append(W83bDelegadosBD.baja).append(" = ");
		strSql.append(" BAJA.").append(W83bMotivosBajaDelegadoBD.codMotivo).append("(+)");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		params.add(param.getVersion());
		HashMap resultado = W83bDataBase.executeQueryHashMap(strSql.toString(),params,W83bListaDelegadosBean.class,param.getUsuarioBean(), "DETALLE","dni");
		//TERMINAR USUARIO
		W83bDataBase.terminarUsuarioAuditor();
		
		return resultado;
		
	}
	
	public String insertarPapeletas(W83bActasBean acta,String colegio) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("INSERT INTO ").append(W83bPapeletasBD.papeletasTable);
		strSql.append("(").append(W83bPapeletasBD.acta).append(",");
		strSql.append(W83bPapeletasBD.anyoActa).append(",");
		strSql.append(W83bPapeletasBD.versionActa).append(",");
		strSql.append(W83bPapeletasBD.territorioActa).append(",");
		strSql.append(W83bPapeletasBD.codColegio).append(",");
		strSql.append(W83bPapeletasBD.validas).append(",");
		strSql.append(W83bPapeletasBD.nulas).append(",");
		strSql.append(W83bPapeletasBD.blancas).append(",");
		strSql.append(W83bPapeletasBD.electores).append(",");
		strSql.append(W83bPapeletasBD.votantes).append(") VALUES (?,?,?,?,?,?,?,?,?,?)");
		params.add(acta.getNumActa());
		params.add(acta.getNumActaAno());
		params.add(acta.getVersion());
		params.add(acta.getNumActaTerritorio());
		if(("0").equals(colegio)){
			params.add(new Integer(acta.getColegios().getCod1()));
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getPapeletasValidasC1())){
				params.add(new Integer(acta.getDatosEscrutinio().getPapeletasValidasC1()));
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getPapeletasNulasC1())){
				params.add(new Integer(acta.getDatosEscrutinio().getPapeletasNulasC1()));
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getPapeletasBlancasC1())){
				params.add(new Integer(acta.getDatosEscrutinio().getPapeletasBlancasC1()));
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getElectoresTotalColegioC1())){
				params.add(new Integer(acta.getDatosEscrutinio().getElectoresTotalColegioC1()));
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getVotantesTotalColegioC1())){
				params.add(new Integer(acta.getDatosEscrutinio().getVotantesTotalColegioC1()));
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			
		}
		else{
			params.add(new Integer(acta.getColegios().getCod2()));
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getPapeletasValidasC2())){
				params.add(new Integer(acta.getDatosEscrutinio().getPapeletasValidasC2()));
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getPapeletasNulasC2())){
				params.add(new Integer(acta.getDatosEscrutinio().getPapeletasNulasC2()));
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getPapeletasBlancasC2())){
				params.add(new Integer(acta.getDatosEscrutinio().getPapeletasBlancasC2()));
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getElectoresTotalColegioC2())){
				params.add(new Integer(acta.getDatosEscrutinio().getElectoresTotalColegioC2()));
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getVotantesTotalColegioC2())){
				params.add(new Integer(acta.getDatosEscrutinio().getVotantesTotalColegioC2()));
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
		}
		W83bDataBase.executeTableMovement(strSql.toString(), params,acta.getUsuarioBean());
		return "0";
	}
	public java.util.List buscarPapeletas(w83b.w83bBeans.W83bActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bPapeletasBD.blancas).append(",");
		strSql.append(W83bPapeletasBD.validas).append(",");
		strSql.append(W83bPapeletasBD.nulas).append(",");
		strSql.append(W83bPapeletasBD.codColegio).append(",");
		strSql.append(W83bPapeletasBD.electores).append(",");
		strSql.append(W83bPapeletasBD.votantes);
		strSql.append(" FROM ").append(W83bPapeletasBD.papeletasTable);
		strSql.append(" WHERE ").append(W83bPapeletasBD.acta).append(" = ? ");
		strSql.append(" AND ").append(W83bPapeletasBD.anyoActa).append(" = ? ");
		strSql.append(" AND ").append(W83bPapeletasBD.territorioActa).append(" = ? ");
		strSql.append(" AND ").append(W83bPapeletasBD.versionActa).append(" = ? ");
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		params.add(param.getVersion());
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bPapeletasBean.class,param.getUsuarioBean(), null);
		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIActasDAO#insertarDocsActas(w83b.w83bBeans.W83bDocBean)
	 */
	public String insertarDocsActas(w83b.w83bBeans.W83bDocBean param,String idioma,String dni) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		String[] tipos=param.getTipoDocumento().split("_");
		
		String resultado = "";
		
			strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			params = new ArrayList();

			strSql.append("INSERT INTO ").append(W83bActasBD.actas_docsTable).append("(");
			strSql.append(W83bActasBD.doc_id).append(",");
			strSql.append(W83bActasBD.doc_nombre).append(",");
			strSql.append(W83bActasBD.doc_longitud).append(",");
			strSql.append(W83bActasBD.doc_documento).append(",");
			strSql.append(W83bActasBD.doc_territActa).append(",");
			strSql.append(W83bActasBD.doc_tram).append(",");
			strSql.append(W83bActasBD.doc_fase).append(",");
			strSql.append(W83bActasBD.doc_anyoActa).append(",");
			strSql.append(W83bActasBD.doc_numActa).append(",");
			strSql.append(W83bActasBD.doc_versionActa).append(",");
			strSql.append(W83bActasBD.doc_tipo).append(",");
			strSql.append(W83bActasBD.doc_numReg).append(",");
			strSql.append(W83bActasBD.doc_fechaReg).append(",");
			strSql.append(W83bActasBD.doc_usuario).append(")");
			strSql.append(" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,to_Date(?,?),?)");
			params.add(param.getId());
			params.add(param.getNombre().toUpperCase());
			params.add(new Integer(param.getTamanyo()));
			if(null!=param.getFileData()){
				params.add(param.getFileData());
			}else{
				params.add(param.getFileDataBlob());				
			}
			params.add(param.getNumActaTerritorio().toUpperCase());
			params.add(tipos[2]);
			params.add(tipos[1]);
			params.add(param.getNumActaAno().toUpperCase());
			params.add(param.getNumActa());
			params.add(param.getVersionActa());
			params.add (tipos[0]);
			if (StringUtils.isNotEmpty(param.getNumeroRegistro())){
				params.add(param.getNumeroRegistro().toString());
			}
			else{
				params.add(W83bClsConstantes.NULL_STRING);
			}
			if (StringUtils.isNotEmpty(param.getFechaRegistro())){
				params.add(param.getFechaRegistro());
				if(param.getFechaRegistro().length()>10){
					params.add(W83bDateUtil.getInstance().devolverFormatoHoraVeinticuatroAlternativaIdioma(idioma));
				}else{
					params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));					
				}
			}
			else{
				params.add(W83bClsConstantes.NULL_DATE);
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
			}
			params.add(param.getUsuario().toUpperCase());
			
			W83bDataBase.executeBlobTableMovement(strSql.toString(), params,param.getTamanyo(),param.getUsuarioBean());
			
			params.clear();
			
			
			
			if ("0".equals(param.getUsuarioBean().getRegManual())
					&&StringUtils.isNotEmpty(param.getFlag()))//es registro automatico
			{
			
				StringBuffer strSqlLibro = new StringBuffer(W83bClsConstantes.CUARENTA);
				ArrayList paramsLibro = new ArrayList();
				 
				strSqlLibro.append("UPDATE ") ;
				strSqlLibro.append(W83bActasBD.actas_docsTable);
				strSqlLibro.append(" SET ");
				strSqlLibro.append(W83bActasBD.doc_fechaReg);
				strSqlLibro.append(" = to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO+"')");
				strSqlLibro.append(",");
				strSqlLibro.append(W83bActasBD.doc_numReg);
				strSqlLibro.append(" = ?");
				strSqlLibro.append(" WHERE ").append(W83bActasBD.doc_territActa).append(" = ? ");
				strSqlLibro.append(" AND ").append(W83bActasBD.doc_anyoActa).append(" = ? ");
				strSqlLibro.append(" AND ").append(W83bActasBD.doc_numActa).append(" = ? ");
				strSqlLibro.append(" AND ").append(W83bActasBD.doc_versionActa).append(" = ? ");
				strSqlLibro.append(" AND ").append(W83bActasBD.doc_id).append(" = ? ");
				//libro de registro

				//Libro Registro
				 String observaciones="Acta n: "+param.getNumActaTerritorio()+"/"+param.getNumActaAno()+"/"+param.getNumActa();//NOPMD
				 String empresa="";
				 empresa=dni;
					
				 W83bUsuarioXLNetsBean usuarioLimitado = ((W83bIComunes)(W83bComunes.class.newInstance())).refrescarUsuarioDelegacion(param.getUsuarioBean());
				 
				 param.getUsuarioBean().setModelo(usuarioLimitado.getModelo());
				 param.getUsuarioBean().setModeloSal(usuarioLimitado.getModeloSal());
				try{ 				 
					String [] resul=W83bLibroRegistro.getAltaRegistro(true, param.getUsuarioBean().getModelo(), "E", "E", empresa, param.getNumActaTerritorio(), "", observaciones, param.getUsuarioBean());
					//Fin Libro Registro
					paramsLibro.add(resul[1]);
					paramsLibro.add(resul[0]);
					paramsLibro.add(param.getNumActaTerritorio());
					paramsLibro.add(param.getNumActaAno());
					paramsLibro.add(param.getNumActa());
					paramsLibro.add(param.getVersionActa());
					paramsLibro.add(param.getId());
					
					W83bDataBase.executeTableMovement(strSqlLibro.toString(), paramsLibro,param.getUsuarioBean());
				}catch(W83bLibroRegistroException e){
					resultado = "true";
				}
				
				
				paramsLibro.clear();
			}
			
			
	return resultado;
}
	public List cargaTiposDocumentoActas(HashMap param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		//obtengo los documentos
		strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bTiposDocumentosVistaBD.tipoDocFasTram);
		strSql.append(",");
		strSql.append(W83bTiposDocumentosVistaBD.fase);
		strSql.append(",");
		strSql.append(W83bTiposDocumentosVistaBD.tramite);
		strSql.append(",");
		if (W83bClsConstantes.CONSTANTE_CASTELLANO.equals(param.get("strIdioma"))){
			strSql.append(W83bTiposDocumentosVistaBD.descFase).append(" AS DESCFASE , ");
			strSql.append(W83bTiposDocumentosVistaBD.descTramite).append(" AS DESCTRAMITE, ");
			strSql.append(W83bTiposDocumentosVistaBD.descTipoDoc).append(" AS DESCRIPCION ");
		}else{
			strSql.append(W83bTiposDocumentosVistaBD.deseFase).append(" AS DESCFASE , ");
			strSql.append(W83bTiposDocumentosVistaBD.deseTramite).append(" AS DESCTRAMITE, ");
			strSql.append(W83bTiposDocumentosVistaBD.deseTipoDoc).append(" AS DESCRIPCION ");
		}
		strSql.append(" FROM ");
		strSql.append(W83bTiposDocumentosVistaBD.vista);
		strSql.append(" WHERE ");
		/*strSql.append(" WHERE (");
		strSql.append(W83bTiposDocumentosVistaBD.tramite).append(" = ?");
		strSql.append(" OR ").append(W83bTiposDocumentosVistaBD.tramite).append(" = ?)");
		strSql.append(" AND ");*/
		strSql.append(W83bTiposDocumentosVistaBD.fase).append(" = ?");
		strSql.append(" ORDER BY DESCRIPCION");
		List listaTiposDocsAux=null;
		List listaTiposDocsResult=new ArrayList();
		
		/*if(((String)param.get("modoAcceso")).equals(W83bClsConstantes.MODO_ALTA)){
			params.add(W83bClsConstantes.TRAMITE_ACTA_ALTA);
		}
		else{
			params.add(W83bClsConstantes.TRAMITE_ACTA_EDICION);
		}
		params.add(W83bClsConstantes.TRAMITE_SINESPECIFICAR);*/
		
		params.add(W83bClsConstantes.FASE_ACTA);
		listaTiposDocsAux=W83bDataBase.executeQuery(strSql.toString(),params,W83bTipoDocumentoBean.class,null, "actas");
		for (int j=0;j<listaTiposDocsAux.size();j++)
		{
			listaTiposDocsResult.add(listaTiposDocsAux.get(j));
		}
		params.clear();
		
		return listaTiposDocsResult;
	}
	public String maxCodDocAdjunto() throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT NVL(MAX(");
		strSql.append(W83bActasBD.doc_id);
		
		strSql.append("),0) FROM ").append(W83bActasBD.actas_docsTable);
		
		List listaCodigos = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		return listaCodigos.get(0).toString(); 		
	}
	public List obtenerDocsActas(w83b.w83bBeans.W83bActasBean param) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.doc_id).append(", ");
		strSql.append(W83bActasBD.doc_nombre).append(", ");
		strSql.append(W83bActasBD.doc_territActa).append(", ");
		strSql.append(W83bActasBD.doc_anyoActa).append(", ");
		strSql.append(W83bActasBD.doc_numActa).append(", ");
		strSql.append(W83bActasBD.doc_tipo).append(", ");
		strSql.append(W83bActasBD.id_remesa_acuse_020).append(", ");
		strSql.append(W83bActasBD.cod_remesa_acuse_020).append(", ");
		strSql.append(W83bActasBD.id_coleccion_acuse_020).append(", ");
		strSql.append(W83bActasBD.cod_coleccion_acuse_020).append(", ");
		strSql.append(W83bActasBD.id_envio_acuse_020).append(", ");
		strSql.append(W83bActasBD.cod_envio_acuse_020).append(", ");
		
		if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83bActasBD.tip_descCast).append(" DESCRIPCION, ");
			strSql.append(W83bActasBD.doc_descCastFase).append(" FASE, ");
			strSql.append(W83bActasBD.doc_descCastTramite).append(" TRAMITE, ");
		}else{
			strSql.append(W83bActasBD.tip_descEusk).append(" DESCRIPCION, ");
			strSql.append(W83bActasBD.doc_descEuskFase).append(" FASE, ");
			strSql.append(W83bActasBD.doc_descEuskTramite).append(" TRAMITE, ");
		}
		strSql.append(W83bActasBD.doc_numReg).append(", TO_CHAR(");
		strSql.append(W83bActasBD.doc_fechaReg).append(",?)F_REG_020,  ");
		strSql.append(W83bActasBD.doc_usuario);

		strSql.append(" FROM ").append(W83bActasBD.actas_docView);
		
		strSql.append(" WHERE ").append(W83bActasBD.doc_territActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.doc_anyoActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.doc_numActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.doc_versionActa).append(" = ?");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		params.add(param.getNumActaTerritorio());		
		params.add(param.getNumActaAno());
		params.add(param.getNumActa());
		params.add(param.getVersion());//la version
		
		List listaDocumentos = W83bDataBase.executeQuery(strSql.toString(),params,W83bDocBean.class,null, "actas");
		
		return listaDocumentos;

		
	
	}
public W83bDocBean descargarDocumentoActas(String param) throws Exception {
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.doc_nombre).append(",");
		strSql.append(W83bActasBD.doc_longitud).append(",");
		strSql.append(W83bActasBD.doc_documento);
		strSql.append(" FROM ").append(W83bActasBD.actas_docsTable);
		//TODO cambiar por id_doc_037
		strSql.append(" WHERE ").append(W83bActasBD.doc_id).append(" = ?");
		
		params.add(param);		
		
		List listaDocumentos = W83bDataBase.executeQuery(strSql.toString(),params,W83bDocBean.class,null, "actas");
		
		if (listaDocumentos.size()>0)
			return (W83bDocBean)listaDocumentos.get(0);
		else
			throw new Exception("No existe ese documento");

		

	}
public List obtenerActasParciales(w83b.w83bBeans.W83bActasBean param) throws Exception {
	StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	List params = new ArrayList();
	strSql.append("SELECT ");
	strSql.append("PAR.").append(W83bActasBD.par_numActa).append(" N_ACTA_016,");
	strSql.append("PAR.").append(W83bActasBD.par_numRegDef).append(" N_REGDEF_016, TO_CHAR (PAR.");
	strSql.append(W83bActasBD.par_fRegDef).append(",?) FREGDEF_016, TO_CHAR(PAR.");
	strSql.append(W83bActasBD.par_fEntrada).append(",?) F_ENTRA_016, TO_CHAR (PAR.");
	strSql.append(W83bActasBD.par_fEleccion).append(",?) F_ELECC_016, TO_CHAR ( PAR.");
	strSql.append(W83bActasBD.par_fComision).append(", ?) F_COMIS_016, TO_CHAR (PAR.");
	strSql.append(W83bActasBD.par_fBaja).append(", ?) F_BAJA_016, ");
	strSql.append("PAR.").append(W83bActasBD.par_numPreaviso).append(" N_PREAVISO_016,");
	strSql.append("PAR.").append(W83bActasBD.par_codConvenio).append(" C_CONV_016,");
	strSql.append("PAR.").append(W83bActasBD.par_codBaja).append(" CBAJA_016, ");
	strSql.append("PAR.").append(W83bActasBD.par_tElectores).append(" TOTELEC_016,");
	strSql.append("PAR.").append(W83bActasBD.par_tCandidatos).append(" TOTALCANDIDATOS,");
	if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)){
		strSql.append("PAR.").append(W83bActasBD.par_descConvenio).append(" DESC_CONVENIO ");
	}
	else{
		strSql.append("PAR.").append(W83bActasBD.par_deseConvenio).append(" DESC_CONVENIO ");
	}
	strSql.append(" FROM ").append(W83bActasBD.actas_parcialesView);
	strSql.append(" PAR WHERE ").append(W83bActasBD.par_numActaTotal).append(" = ?");
	strSql.append(" AND ");
	strSql.append(W83bActasBD.par_anyoActaTotal).append(" = ?");
	strSql.append(" AND ");
	strSql.append(W83bActasBD.par_territorio).append(" = ?");
	strSql.append(" AND ");
	strSql.append(W83bActasBD.par_vers).append(" = (select max(").append(W83bActasBD.par_vers);
	strSql.append(") from ").append(W83bActasBD.actas_parcialesView);
	strSql.append(" TEMP WHERE TEMP.").append(W83bActasBD.par_numActaSing).append(" = PAR.");
	strSql.append(W83bActasBD.par_numActaSing);
	strSql.append(" AND TEMP.").append(W83bActasBD.par_anyoActa).append(" = PAR.");
	strSql.append(W83bActasBD.par_anyoActa);
	strSql.append(" AND TEMP.").append(W83bActasBD.par_terActa).append(" = PAR.");
	strSql.append(W83bActasBD.par_terActa).append(")");

	params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	
	params.add(param.getNumActa());		
	params.add(param.getNumActaAno());
	params.add(param.getNumActaTerritorio());
	if(param.getIdColumna()!=null&&!param.getIdColumna().equals("")){
		String[] ordenacion=param.getIdColumna().split(",");
		
		strSql.append(" ORDER BY ");
		for(int i=0;i<ordenacion.length;i++)
		{
			if(i!=0)
			{
				strSql.append(", ");
			}
				strSql.append(ordenacion[i]).append(" ").append(param.getSort());	
		}
	}
	List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bActasBean.class,null, "DETALLE");
	
	return listaActas;

	

}
public String editarActa(W83bActasBean acta) throws Exception{
	String formato=W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma());
	StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	List params = new ArrayList();
	strSql.append("UPDATE "+W83bActasBD.actasTable+" SET ");
	
	strSql.append(W83bActasBD.numPreaviso).append("=?, ");
	strSql.append(W83bActasBD.anyoPreaviso).append("=?, ");
	strSql.append(W83bActasBD.codConvenio).append("=?, ");
	strSql.append(W83bActasBD.codCentro).append("=?, ");
	strSql.append(W83bActasBD.codMotivosBaja).append("=?, ");
	strSql.append(W83bActasBD.fechaEntrada).append("=to_Date(?,?), ");
	strSql.append(W83bActasBD.fechaEleccion).append("=to_Date(?,?), ");
	strSql.append(W83bActasBD.totalElectores).append("=?, ");
	strSql.append(W83bActasBD.nCandidatosHombre).append("=?, ");
	strSql.append(W83bActasBD.nCandidatosMujer).append("=?, ");
	strSql.append(W83bActasBD.fechaComision).append("=to_Date(?,?), ");
	strSql.append(W83bActasBD.fechaBaja).append("=to_Date(?,?), ");
	//mejoras flex1if (!"0".equals(acta.getUsuarioBean().getRegManual())){//es registro manual
		strSql.append(W83bActasBD.fechaRegistro);
		strSql.append(" = to_date(?,?)");
		strSql.append(",");
		strSql.append(W83bActasBD.numRegistro);
		strSql.append(" = ?");
		strSql.append(",");
	//}
	
	strSql.append(W83bActasBD.nElectoresHombre).append("=?, ");
	strSql.append(W83bActasBD.nElectoresMujer).append("=?, ");
	strSql.append(W83bActasBD.totaldel).append("=?, ");
	strSql.append(W83bActasBD.delHombres).append("=?, ");
	strSql.append(W83bActasBD.delMujeres).append("=?, ");
	strSql.append(W83bActasBD.marcaComision).append("=?, ");
	strSql.append(W83bActasBD.observaciones).append("=?, ");
	
	strSql.append(W83bActasBD.inspeccionada).append("=?, ");//20
	strSql.append(W83bActasBD.maxDel).append("=?, ");
	strSql.append(W83bActasBD.REMITE_016).append("=?, ");
	strSql.append(W83bActasBD.F_CONSTCOM_016).append("=to_Date(?,?) ");
	strSql.append(" WHERE ");
	strSql.append(W83bActasBD.numActa).append("=? AND ");
	strSql.append(W83bActasBD.anyoActa).append("=? AND ");
	strSql.append(W83bActasBD.versionActa).append("=? AND ");
	strSql.append(W83bActasBD.codTerritActa).append("=? ");
	
	if(StringUtils.isNotEmpty(acta.getNumPreaviso())){
		params.add(acta.getNumPreaviso());
	}
	else{
		params.add(W83bClsConstantes.NULL_INTEGER);
	}
	if(StringUtils.isNotEmpty(acta.getAnyoPreaviso())){
		params.add(acta.getAnyoPreaviso());
	}
	else{
		params.add(W83bClsConstantes.NULL_INTEGER);
	}
	
	params.add(acta.getCodConvenio());
	params.add(acta.getCodCentroTrabajo());
	if(StringUtils.isNotEmpty(acta.getMotivoBaja())){
		params.add(acta.getMotivoBaja());
	}
	else{
		params.add(W83bClsConstantes.NULL_STRING);			
	}
	params.add(acta.getFechaEntrada());//10
	params.add(formato);
	params.add(acta.getFechaEleccion());
	params.add(formato);
	
	params.add(acta.getElectoresTotal());
	params.add(acta.getCandidatosHombres());
	params.add(acta.getCandidatosMujeres());
	
	
	
	if(StringUtils.isNotEmpty(acta.getFechaComision())){
		params.add(acta.getFechaComision());
	}
	else{
		params.add(W83bClsConstantes.NULL_DATE);			
	}
	params.add(formato);
	
	if(StringUtils.isNotEmpty(acta.getFechaBaja())){
		params.add(acta.getFechaBaja());
	}
	else{
		params.add(W83bClsConstantes.NULL_DATE);			
	}
	params.add(formato);
	//mejoras flex1if (!"0".equals(acta.getUsuarioBean().getRegManual())){//es registro manual
		if(StringUtils.isNotEmpty(acta.getFechaRegistroES())){
			params.add(acta.getFechaRegistroES());
		}
		else{
			params.add(W83bClsConstantes.NULL_DATE);			
		}
		params.add(formato);
		if(StringUtils.isNotEmpty(acta.getNumRegistroES())){
			params.add(acta.getNumRegistroES().toUpperCase());
		}
		else{
			params.add(W83bClsConstantes.NULL_STRING);			
		}
	//}
	
	params.add(acta.getElectoresHombres());
	
	params.add(acta.getElectoresMujeres());
	
	if(StringUtils.isNotEmpty(acta.getDelegadosTotal()))
		params.add(acta.getDelegadosTotal());
	else
		params.add("0");			
	
	if(StringUtils.isNotEmpty(acta.getDelegadosHombres())){
		params.add(acta.getDelegadosHombres());
	}
	else{
		params.add("0");			
	}
	
	if(StringUtils.isNotEmpty(acta.getDelegadosMujeres()))
		params.add(acta.getDelegadosMujeres());
	
	else
		params.add("0");			
	
	
	if(StringUtils.isNotEmpty(acta.getComision())){
		params.add(acta.getComision());
	}
	else{
		params.add(W83bClsConstantes.NULL_STRING);			
	}
	
	if(StringUtils.isNotEmpty(acta.getObservaciones()))
		params.add(acta.getObservaciones().toUpperCase());
	else
		params.add(W83bClsConstantes.NULL_STRING);			
	
	
	if(StringUtils.isNotEmpty(acta.getInspeccionada())){
		params.add(acta.getInspeccionada());
	}
	else{
		params.add(W83bClsConstantes.NULL_INTEGER);			
	}
	
	
	params.add(acta.getDelegadosMaximo());
	if(StringUtils.isNotEmpty(acta.getRemitente())){
		params.add(acta.getRemitente().toUpperCase());
	}else{
		params.add(W83bClsConstantes.NULL_STRING);	
	}
	params.add(W83bClsConstantes.NULL_DATE);//????que es esto???	
	params.add(formato);
	params.add(acta.getNumActa());
	params.add(acta.getNumActaAno());
	params.add(acta.getVersion());
	params.add(acta.getNumActaTerritorio());
	W83bDataBase.executeTableMovement(strSql.toString(), params,acta.getUsuarioBean());
	return "0";
}
public String editarActaRegDef(W83bActasBean acta) throws Exception{
	String formato=W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma());
	StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	List params = new ArrayList();
	strSql.append("UPDATE "+W83bActasBD.actasTable+" SET ");
	
	strSql.append(W83bActasBD.anyoRegDefinitivo).append("=?, ");
	strSql.append(W83bActasBD.numRegDefinitivo).append("=?, ");
	strSql.append(W83bActasBD.fecRegDefinitivo).append("=to_Date(?,?) ");
	strSql.append(" WHERE ");
	strSql.append(W83bActasBD.numActa).append("=? AND ");
	strSql.append(W83bActasBD.anyoActa).append("=? AND ");
	strSql.append(W83bActasBD.versionActa).append("=? AND ");
	strSql.append(W83bActasBD.codTerritActa).append("=? ");
	
	if(StringUtils.isNotEmpty(acta.getNumRegAnyo())){
		params.add(acta.getNumRegAnyo());
	}
	else{
		params.add(W83bClsConstantes.NULL_INTEGER);			
	}
	if(StringUtils.isNotEmpty(acta.getNumRegDefinitivo())){
		String numRegDef = acta.getNumRegDefinitivo();
		
		if(1<numRegDef.split("/").length){
			numRegDef = numRegDef.split("/")[numRegDef.split("/").length-1];
		}
		
		params.add(numRegDef);
	}
	else{
		params.add(W83bClsConstantes.NULL_INTEGER);			
	}
	if(StringUtils.isNotEmpty(acta.getFechaRegistroDefinitivo())){
		params.add(acta.getFechaRegistroDefinitivo());
	}
	else{
		params.add(W83bClsConstantes.NULL_DATE);			
	}
	params.add(formato);
	
	params.add(acta.getNumActa());
	params.add(acta.getNumActaAno());
	params.add(acta.getVersion());
	params.add(acta.getNumActaTerritorio());
	W83bDataBase.executeTableMovement(strSql.toString(), params,acta.getUsuarioBean());
	return "0";
}

//david 17/07/2013 Comision Masiva INI
public String editarActaFechaComision(W83bActasBean acta) throws Exception{
	String formato=W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma());
	StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	List params = new ArrayList();
	strSql.append("UPDATE "+W83bActasBD.actasTable+" SET ");	
	strSql.append(W83bActasBD.fechaComision).append("=to_Date(?,?) ");
	strSql.append(" WHERE ");
	strSql.append(W83bActasBD.numActa).append("=? AND ");
	strSql.append(W83bActasBD.anyoActa).append("=? AND ");
	strSql.append(W83bActasBD.versionActa).append("=? AND ");
	strSql.append(W83bActasBD.codTerritActa).append("=? ");
	
	
	if(StringUtils.isNotEmpty(acta.getFechaComision())){
		params.add(acta.getFechaComision());
	}
	else{
		params.add(W83bClsConstantes.NULL_DATE);			
	}

	params.add(formato);	
	String strDatos=acta.getNumActa();
	StringTokenizer tokens=new StringTokenizer(strDatos, "/");
//	El acta es de la forma 48/2013/000005
	String strCodTerritActa=tokens.nextToken();
	String strAnyoActa=tokens.nextToken();
	String strNumActa=tokens.nextToken();	
	params.add(strNumActa);
	params.add(strAnyoActa);
	params.add(acta.getVersion());
	params.add(strCodTerritActa);
	W83bDataBase.executeTableMovement(strSql.toString(), params,acta.getUsuarioBean());
	return "0";
}

public boolean blnActaBaja(W83bActasBean acta) throws Exception{

		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.fechaBaja);
		
		strSql.append(" FROM ").append(W83bActasBD.actasTable);
		strSql.append(" WHERE ").append(W83bActasBD.anyoActa).append("=?");
		strSql.append(" AND  ").append(W83bActasBD.codTerritActa).append("=?");
		strSql.append(" AND  ").append(W83bActasBD.numActa).append("=?");
		strSql.append(" AND  ").append(W83bActasBD.versionActa).append("=?");
		
		String strDatos=acta.getNumActa();
		StringTokenizer tokens=new StringTokenizer(strDatos, "/");
//		El acta es de la forma 48/2013/000005
		String strCodTerritActa=tokens.nextToken();
		String strAnyoActa=tokens.nextToken();
		String strNumActa=tokens.nextToken();	
		params.add(strAnyoActa);
		params.add(strCodTerritActa);
		params.add(strNumActa);		
		params.add(acta.getVersion());		
		
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		if (listaActas.get(0)!=null && listaActas.get(0).toString().length()>0){//NOPMD
			return true;
		}else{
			return false;
		}
}
//david 17/07/2013 Comision Masiva FIN

public boolean existeEscrutinio(w83b.w83bBeans.W83bListaEscrutiniosBean param) throws Exception{
	StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	List params = new ArrayList();
	strSql.append("SELECT ");
	strSql.append(W83bEscrutiniosBD.codSind);
	strSql.append(" FROM ").append(W83bEscrutiniosBD.escrutTable);
	strSql.append(" WHERE ").append(W83bEscrutiniosBD.codSind).append("=? AND ");
	strSql.append(W83bEscrutiniosBD.acta).append("=? AND ");
	strSql.append(W83bEscrutiniosBD.territorioActa).append("=? AND ");
	strSql.append(W83bEscrutiniosBD.anyoActa).append("=? AND ");
	strSql.append(W83bEscrutiniosBD.codigoColegio).append("=? AND ");
	strSql.append(W83bEscrutiniosBD.versionActa).append("=?");
	params.add(param.getSindicato());
	params.add(param.getActa());
	params.add(param.getTerritorioActa());
	params.add(param.getAnyoActa());
	params.add(param.getCodColegio());
	params.add(param.getVersionActa());
	List lista=W83bDataBase.executeQuery(strSql.toString(),params, W83bListaEscrutiniosBean.class, param.getUsuarioBean(),null);
		
	return (lista.size()>0);
		
}
public boolean existeDiferencia(w83b.w83bBeans.W83bListaDiferenciasBean param) throws Exception{
	StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	List params = new ArrayList();
	strSql.append("SELECT ");
	strSql.append(W83bDiferenciasBD.codSind);
	strSql.append(" FROM ").append(W83bDiferenciasBD.difTable);
	strSql.append(" WHERE ").append(W83bDiferenciasBD.codSind).append(" =? AND ");
	strSql.append(W83bDiferenciasBD.acta).append("=? AND ");
	strSql.append(W83bDiferenciasBD.territorioActa).append("=? AND ");
	strSql.append(W83bDiferenciasBD.anyoActa).append("=? AND ");
	strSql.append(W83bDiferenciasBD.codigoColegio).append("=? AND ");
	strSql.append(W83bDiferenciasBD.versionActa).append("=? ");
	params.add(param.getSindicato());
	params.add(param.getActa());
	params.add(param.getTerritorioActa());
	params.add(param.getAnyoActa());
	params.add(param.getCodColegio());
	params.add(param.getVersionActa());
	List lista=W83bDataBase.executeQuery(strSql.toString(),params,W83bListaDiferenciasBean.class,param.getUsuarioBean(), null);
	return(lista.size()>0);
		
}
public boolean existePapeletas(w83b.w83bBeans.W83bActasBean param,String colegio) throws Exception{
	StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	List params = new ArrayList();
	strSql.append("SELECT ");
	strSql.append(W83bPapeletasBD.acta);
	strSql.append(" FROM ").append(W83bPapeletasBD.papeletasTable);
	strSql.append(" WHERE ");
	strSql.append(W83bPapeletasBD.acta).append("=? AND ");
	strSql.append(W83bPapeletasBD.territorioActa).append("=? AND ");
	strSql.append(W83bPapeletasBD.anyoActa).append("=? AND ");
	strSql.append(W83bPapeletasBD.codColegio).append("=? AND ");
	strSql.append(W83bPapeletasBD.versionActa).append("=? ");
	params.add(param.getNumActa());
	params.add(param.getNumActaTerritorio());
	params.add(param.getNumActaAno());
	params.add(colegio);
	params.add(param.getVersion());
	List lista=W83bDataBase.executeQuery(strSql.toString(),params,W83bPapeletasBean.class,param.getUsuarioBean(), null);
	return(lista.size()>0);
	
}
public boolean existeListaDelegados(w83b.w83bBeans.W83bListaDelegadosBean param) throws Exception{
	StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	//IDENTIFICAR USUARIO
	W83bDataBase.identificarUsuarioAuditor(param.getUsuarioBean().getIdUsuario());
	
	List params = new ArrayList();
	strSql.append("SELECT ");
	strSql.append(W83bDelegadosBD.dni);
	strSql.append(" FROM ").append(W83bDelegadosBD.delegadosTable);
	strSql.append(" WHERE ").append(W83bDelegadosBD.dni).append(" =? AND  ");
	strSql.append(W83bDelegadosBD.acta).append("=? AND ");
	strSql.append(W83bDelegadosBD.territorioActa).append("=? AND ");
	strSql.append(W83bDelegadosBD.anyoActa).append("=? AND ");
	strSql.append(W83bDelegadosBD.versionActa).append("=? ");
	params.add(param.getDni());
	params.add(param.getActa());
	params.add(param.getTerritorioActa());
	params.add(param.getAnyoActa());
	params.add(param.getVersionActa());
	List lista=W83bDataBase.executeQuery(strSql.toString(),params,W83bListaDelegadosBean.class,param.getUsuarioBean(), null);
	//TERMINAR USUARIO
	W83bDataBase.terminarUsuarioAuditor();
	
	return(lista.size()>0);
	
}
public String modificarDiferencia(W83bListaDiferenciasBean diferencia,String usuario) throws Exception{
	StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	List params = new ArrayList();
	strSql.append("UPDATE "+W83bDiferenciasBD.difTable+" SET ");
	strSql.append(W83bDiferenciasBD.delegadosHombres).append("=?,");
	strSql.append(W83bDiferenciasBD.delegadosMujeres).append("=?,");
	strSql.append(W83bDiferenciasBD.usuario).append("=?,");
	strSql.append(W83bDiferenciasBD.fecha).append("=to_Date(?,?) ");
	strSql.append(" WHERE ");
	strSql.append(W83bDiferenciasBD.codigoColegio).append("=? AND ");
	strSql.append(W83bDiferenciasBD.acta).append("=? AND ");
	strSql.append(W83bDiferenciasBD.anyoActa).append("=? AND ");
	strSql.append(W83bDiferenciasBD.territorioActa).append("=? AND ");
	strSql.append(W83bDiferenciasBD.versionActa).append("=? AND ");
	strSql.append(W83bDiferenciasBD.codSind).append("=?");
	
	
	params.add(diferencia.getHombres());
	params.add(diferencia.getMujeres());
	params.add(usuario);
	
	SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
	params.add(sdf.format(new Date()));
	params.add(W83bDateUtil.ES_PATTERN);
	params.add(diferencia.getCodColegio());
	params.add(diferencia.getActa());
	params.add(diferencia.getAnyoActa());
	params.add(diferencia.getTerritorioActa());
	params.add(diferencia.getVersionActa());
	params.add(diferencia.getSindicato());
	
	W83bDataBase.executeTableMovement(strSql.toString(), params,diferencia.getUsuarioBean());
	
	return "0";	
}
public String modificarEscrutinio(W83bListaEscrutiniosBean escrutinio,String usuario) throws Exception{
	StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	List params = new ArrayList();
	strSql.append("UPDATE "+W83bEscrutiniosBD.escrutTable+" SET ");
	
	
	strSql.append(W83bEscrutiniosBD.delegadosHombres).append("=?,");
	strSql.append(W83bEscrutiniosBD.delegadosMujeres).append("=?,");
	strSql.append(W83bEscrutiniosBD.numVotos).append("=?,");
	strSql.append(W83bEscrutiniosBD.usuario).append("=?,");
	strSql.append(W83bEscrutiniosBD.fecha).append("=to_Date(?,?) ");
	strSql.append(" WHERE ");
	
	strSql.append(W83bEscrutiniosBD.acta).append("=? AND ");
	strSql.append(W83bEscrutiniosBD.anyoActa).append("=? AND ");
	strSql.append(W83bEscrutiniosBD.territorioActa).append("=? AND ");
	strSql.append(W83bEscrutiniosBD.versionActa).append("=? AND ");
	strSql.append(W83bEscrutiniosBD.codSind).append("=? AND ");
	strSql.append(W83bEscrutiniosBD.codigoColegio).append("=?");
	
	params.add(escrutinio.getHombres());
	params.add(escrutinio.getMujeres());
	params.add(escrutinio.getNumVotos());
	params.add(usuario);
	SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
	params.add(sdf.format(new Date()));
	params.add(W83bDateUtil.ES_PATTERN);
	params.add(escrutinio.getActa());
	params.add(escrutinio.getAnyoActa());
	params.add(escrutinio.getTerritorioActa());
	params.add(escrutinio.getVersionActa());
	params.add(escrutinio.getSindicato());
	params.add(escrutinio.getCodColegio());
	W83bDataBase.executeTableMovement(strSql.toString(), params,escrutinio.getUsuarioBean());
	
	return "0";	
}
public String modificarDelegado(W83bListaDelegadosBean delegado,String usuario) throws Exception{
	StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	//IDENTIFICAR USUARIO
	W83bDataBase.identificarUsuarioAuditor(usuario);
	
	List params = new ArrayList();
	strSql.append("UPDATE "+W83bDelegadosBD.delegadosTable+" SET ");
	
	strSql.append(W83bDelegadosBD.codSindicato).append("=?,");
	strSql.append(W83bDelegadosBD.codColegio).append("=?,");
	
	strSql.append(W83bDelegadosBD.nombre).append("=?,");
	strSql.append(W83bDelegadosBD.apellido1).append("=?,");
	strSql.append(W83bDelegadosBD.apellido2).append("=?,");
	strSql.append(W83bDelegadosBD.sexo).append("=?,");
	strSql.append(W83bDelegadosBD.dniSustituto).append("=?,");
	strSql.append(W83bDelegadosBD.fechaBaja).append("=to_Date(?,?),");
	strSql.append(W83bDelegadosBD.baja).append("=?,");
	strSql.append(W83bDelegadosBD.usuario).append("=?,");
	strSql.append(W83bDelegadosBD.fechaMod).append("=to_Date(?,?),");
	strSql.append(W83bDelegadosBD.fechaAlta).append("=to_Date(?,?)");
	strSql.append(" WHERE ");
	strSql.append(W83bDelegadosBD.acta).append("=? AND ");
	strSql.append(W83bDelegadosBD.anyoActa).append("=? AND ");
	strSql.append(W83bDelegadosBD.territorioActa).append("=? AND ");
	strSql.append(W83bDelegadosBD.versionActa).append("=? AND ");
	strSql.append(W83bDelegadosBD.dni).append("=?");
	
	params.add(delegado.getCodSindicato());
	params.add(delegado.getCodColegio());
	params.add(delegado.getNombre());
	params.add(delegado.getApellido1());
	params.add(delegado.getApellido2());
	params.add(delegado.getSexo());
	if(StringUtils.isNotEmpty(delegado.getDniSustituto())){
		params.add(delegado.getDniSustituto());
	}
	else{
		params.add(W83bClsConstantes.NULL_STRING);
	}
	if(StringUtils.isNotEmpty(delegado.getFechaBaja())){
		params.add(delegado.getFechaBaja());
	}
	else{
		params.add(W83bClsConstantes.NULL_DATE);
	}
	params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(delegado.getIdioma()));
	if(StringUtils.isNotEmpty(delegado.getCodBaja())){
		params.add(delegado.getCodBaja());
	}
	else{
		params.add(W83bClsConstantes.NULL_INTEGER);
	}
	
	params.add(usuario);
	SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
	
	params.add(sdf.format(new Date()));
	params.add(W83bDateUtil.ES_PATTERN);
	
	params.add(delegado.getFechaAlta());
	params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(delegado.getIdioma()));
	
	params.add(delegado.getActa());
	params.add(delegado.getAnyoActa());
	params.add(delegado.getTerritorioActa());
	params.add(delegado.getVersionActa());
	params.add(delegado.getDni());
	W83bDataBase.executeTableMovement(strSql.toString(), params,delegado.getUsuarioBean());
	//TERMINAR USUARIO
	W83bDataBase.terminarUsuarioAuditor();
	return "0";	
}
public List buscarDelegadosActa(w83b.w83bBeans.W83bActasBean param) throws Exception{
	StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	//IDENTIFICAR USUARIO
	W83bDataBase.identificarUsuarioAuditor(param.getUsuarioBean().getIdUsuario());
	
	List params = new ArrayList();
	strSql.append("SELECT COUNT(").append(W83bDelegadosBD.dni).append(") AS DELEGADOS,");
	strSql.append(W83bDelegadosBD.dni).append(",").append(W83bDelegadosBD.sexo).append(",").append(W83bDelegadosBD.codSindicato).append(",");
	strSql.append(W83bDelegadosBD.codColegio).append(",").append(W83bDelegadosBD.apellido1).append(",").append(W83bDelegadosBD.apellido2).append(",");
	strSql.append(W83bDelegadosBD.nombre).append(",").append(W83bDelegadosBD.dniSustituto).append(", TO_CHAR(");
	strSql.append(W83bDelegadosBD.fechaAlta).append(",?) ").append(W83bDelegadosBD.fechaAlta).append(", TO_CHAR(");
	strSql.append(W83bDelegadosBD.fechaMod).append(",?) ").append(W83bDelegadosBD.fechaMod).append(", TO_CHAR(");
	strSql.append(W83bDelegadosBD.fechaBaja).append(",?) ").append(W83bDelegadosBD.fechaBaja).append(",");
	strSql.append(W83bDelegadosBD.baja).append(",");
	strSql.append("CASE WHEN ").append(W83bDelegadosBD.codColegio).append("=0 THEN '").append(W83bClsConstantes.CONSTANTE_DESCRIP_TECNICOS).append("' ELSE '").append(W83bClsConstantes.CONSTANTE_DESCRIP_ESPECIALISTAS).append("' END AS COLEGIO").append(",");
	strSql.append(W83bSindicatosBD.siglas).append(" SINDICATO,");
	if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)){
		
		//.append(W83bColegiosBD.descripcion).append(" COLEGIO,");
		strSql.append(W83bColegiosBD.descripcion).append(" AS DESCCOLEGIO,");
		strSql.append(W83bMotivosBajaDelegadoBD.descMotivoCast).append(" BAJA");
	}
	else{

		//.append(W83bColegiosBD.descripcion_eu).append(" COLEGIO,");
		strSql.append(W83bColegiosBD.descripcion_eu).append(" AS DESCCOLEGIO,");
		strSql.append(W83bMotivosBajaDelegadoBD.descMotivoEusk).append(" BAJA");
	}
	
	strSql.append(" FROM ").append(W83bDelegadosBD.delegadosTable).append(",").append(W83bSindicatosBD.sindicatosTable).append(",");
	strSql.append(W83bColegiosBD.colegiosTable).append(",").append(W83bMotivosBajaDelegadoBD.motivosBajaTable);
	strSql.append(" WHERE ").append(W83bDelegadosBD.acta).append("=? AND ").append(W83bDelegadosBD.anyoActa).append("=? AND ");
	strSql.append(W83bDelegadosBD.territorioActa).append("=? AND ").append(W83bDelegadosBD.versionActa).append("=? AND ");
	strSql.append(W83bDelegadosBD.codSindicato).append("=").append(W83bSindicatosBD.codSindicato).append(" AND ");
	strSql.append(W83bDelegadosBD.codColegio).append("=").append(W83bColegiosBD.cod).append(" AND ");
	strSql.append(W83bDelegadosBD.baja).append("=").append(W83bMotivosBajaDelegadoBD.codMotivo).append("(+)");
	strSql.append(" GROUP BY ").append(W83bDelegadosBD.codSindicato).append(", ").append(W83bDelegadosBD.codColegio).append(", ");
	strSql.append(W83bDelegadosBD.sexo).append(", ").append(W83bDelegadosBD.dni).append(", ");
	strSql.append(W83bDelegadosBD.codColegio).append(",").append(W83bDelegadosBD.apellido1).append(",").append(W83bDelegadosBD.apellido2).append(",");
	strSql.append(W83bDelegadosBD.nombre).append(",").append(W83bDelegadosBD.dniSustituto).append(", ");
	strSql.append(W83bDelegadosBD.fechaAlta).append(", ").append(W83bDelegadosBD.fechaBaja).append(",");
	strSql.append(W83bDelegadosBD.fechaMod).append(",");
	strSql.append(W83bDelegadosBD.baja).append(",");
	strSql.append(W83bSindicatosBD.siglas).append(",");
	if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)){
		//strSql.append(W83bSindicatosBD.descSindicatoCast).append(",").append(W83bColegiosBD.descripcion).append(",");
		strSql.append(W83bColegiosBD.descripcion).append(",");
		strSql.append(W83bMotivosBajaDelegadoBD.descMotivoCast);
	}
	else{
		//strSql.append(W83bSindicatosBD.descSindicatoEusk).append(",").append(W83bColegiosBD.descripcion_eu).append(",");
		strSql.append(W83bColegiosBD.descripcion_eu).append(",");
		strSql.append(W83bMotivosBajaDelegadoBD.descMotivoEusk);
	}
	strSql.append(" ORDER BY ");
	strSql.append(" COLEGIO desc,");
	strSql.append(W83bDelegadosBD.dni).append(" asc");
	params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	params.add(param.getNumActa());
	params.add(param.getNumActaAno());
	params.add(param.getNumActaTerritorio());
	params.add(param.getVersion());
	List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bListaDelegadosBean.class,param.getUsuarioBean(), "DETALLE");
	//TERMINAR USUARIO
	W83bDataBase.terminarUsuarioAuditor();
	return listaActas;	
}
public W83bActasBean obtenerImpugnaciones(w83b.w83bBeans.W83bActasBean param)
throws Exception {
	StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
	List params = new ArrayList();
	strSql.append("SELECT ");
	
	strSql.append(W83bActasBD.territ);
	strSql.append("||'/'||");
	strSql.append(W83bActasBD.ano_impug);
	strSql.append("||'/'||");
	strSql.append(" DECODE(LENGTH(TO_CHAR(").append(W83bActasBD.imp_num).append(")),");
	strSql.append(" 1,'00000'||TO_CHAR(").append(W83bActasBD.imp_num).append("),");
	strSql.append(" 2,'00000'||TO_CHAR(").append(W83bActasBD.imp_num).append("),");
	strSql.append(" 3,'00000'||TO_CHAR(").append(W83bActasBD.imp_num).append("),");
	strSql.append(" 4,'00000'||TO_CHAR(").append(W83bActasBD.imp_num).append("),");
	strSql.append(" 5,'00000'||TO_CHAR(").append(W83bActasBD.imp_num).append("),");
	strSql.append(" TO_CHAR(").append(W83bActasBD.imp_num).append("))");
	
	strSql.append(" AS NUM_IMPUGNACION, TO_CHAR (");
	strSql.append(W83bActasBD.imp_fecha).append(",?) FIMPUGNACIONDATE, TO_CHAR(");
	strSql.append(W83bActasBD.imp_fechaLaudo).append(",?) FECHALAUDO, TO_CHAR ( ");
	strSql.append(W83bActasBD.imp_fechaEnvioJuzgado).append(",?) FENVIOJUZGADODATE, TO_CHAR ( ");
	strSql.append(W83bActasBD.imp_fechaSentencia).append(",?) FSENTENCIADATE, TO_CHAR ( ");
	strSql.append(W83bActasBD.imp_fechaBajaDesestimiento).append(",?) FECHADESES, ");
	if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)){
		strSql.append(W83bActasBD.imp_tipoc).append(" AS ").append(W83bActasBD.imp_tipo).append(", ");
	}else{
		strSql.append(W83bActasBD.imp_tipoe).append(" AS ").append(W83bActasBD.imp_tipo).append(", ");
	}
	strSql.append(W83bActasBD.imp_dni).append(", ");
	strSql.append(W83bActasBD.imp_sindicatos).append(", upper(");
	strSql.append(W83bActasBD.imp_nombre).append(") AS NOMARBITRO, ");
	strSql.append(W83bActasBD.imp_numLaudo).append(",");
	strSql.append(W83bActasBD.territ).append(",");;
	strSql.append(W83bActasBD.ano_impug).append(", ");
	strSql.append(W83bActasBD.imp_resultadoLaudo).append(", ");
	strSql.append(W83bActasBD.imp_nombreImpugnante).append(", ");
	if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)){
		strSql.append(W83bImpugnacionesBD.descResultadoLaudo).append(" as ").append(W83bImpugnacionesBD.descResultadoLaudo);		
	}else{
		strSql.append(W83bImpugnacionesBD.descEusResultadoLaudo).append(" as ").append(W83bImpugnacionesBD.descResultadoLaudo);		
	}
	strSql.append(" FROM ").append(W83bActasBD.actas_impugView);
	strSql.append(", ").append(W83bImpugnacionesBD.vistaResultadoLaudo);
	strSql.append(" WHERE ((NUM_ACTA =?");
	strSql.append(" AND ANO_ACTA= ?");
	strSql.append(" AND TERRIT=?) OR (");
	//strSql.append(" RESULTADOLAUDO =?");
	strSql.append("  NUM_PREAVISO=?");//AND
	strSql.append(" AND ANO_PREAVISO=?");
	strSql.append(" AND TERRIT=?)) and ");
	strSql.append(W83bActasBD.imp_resultadoLaudo);
	strSql.append(" = ");
	strSql.append(W83bImpugnacionesBD.numResultadoLaudo);
	strSql.append("(+)");
	params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	
	
	params.add(param.getNumActa());
	params.add(param.getNumActaAno());
	params.add(param.getNumActaTerritorio());
	//params.add("1");
	params.add(param.getNumPreaviso());
	params.add(param.getAnyoPreaviso());
	params.add(param.getNumActaTerritorio());
	if(param.getIdColumna()!=null&&!param.getIdColumna().equals("")){
		String[] ordenacion=param.getIdColumna().split(",");
		
		strSql.append(" ORDER BY ");
		for(int i=0;i<ordenacion.length;i++)
		{
			if(i!=0)
			{
				strSql.append(", ");
			}
				strSql.append(ordenacion[i]).append(" ").append(param.getSort());	
		}
	}
	else{
		strSql.append(" ORDER BY ").append(W83bActasBD.imp_numCompleto);
	}
	List listaImpugnaciones = W83bDataBase.executeQuery(strSql.toString(),params,W83bImpugnacionesBean.class,null, "acta");
	param.setListaImpugnaciones(listaImpugnaciones);
	return param;

}
	public W83bActasBean obtenerHistorialActa(w83b.w83bBeans.W83bActasBean param)throws Exception {
	
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		
		//TODO cambiar a que llegue el idioma
		if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO))
		{
		strSql.append(W83bActasBD.his_desc).append(" AS DESCRIPCION, TO_CHAR(");
		}
		else
		{
		strSql.append(W83bActasBD.his_dese).append(" AS DESCRIPCION, TO_CHAR(");
		}
		strSql.append(W83bActasBD.his_factu).append(",?) FACTU_057, ");
		strSql.append(W83bActasBD.his_usu).append(", ");
		strSql.append(W83bActasBD.his_factu).append(" FECHA ");
		
		
		strSql.append(" FROM ").append(W83bActasBD.historial_Synonym);
		
		strSql.append(" WHERE ").append(W83bActasBD.his_territ).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.his_anyoActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.his_acta).append(" = ?");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		params.add(param.getNumActaTerritorio());		
		params.add(param.getNumActaAno());
		params.add(param.getNumActa());

			strSql.append(" ORDER BY FECHA DESC");
		
		List listaHistorial = W83bDataBase.executeQuery(strSql.toString(),params,W83bHistorialActaBean.class,null, null);
		
		param.setListaHistorial(listaHistorial);
		return param;	
	
	}

	public W83bActasBean obtenerTramitesActas(W83bActasBean param)throws Exception {
	
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.hisTram_codTramite).append(",");
		strSql.append(W83bActasBD.hisTram_codFase).append(",  TO_CHAR(");
		strSql.append(W83bActasBD.hisTram_factu).append(",?)AS ").append(W83bActasBD.hisTram_factu).append(",TO_CHAR( ");
		strSql.append(W83bActasBD.hisTram_fMod).append(",?) AS ").append(W83bActasBD.hisTram_fMod).append(",TO_CHAR( ");
		strSql.append(W83bActasBD.hisTram_fRegSalida).append(",?) AS ").append(W83bActasBD.hisTram_fRegSalida).append(", TO_CHAR(");
		strSql.append(W83bActasBD.hisTram_fAltaTramite).append(",?) AS ").append(W83bActasBD.hisTram_fAltaTramite).append(", ");
		if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83bActasBD.hisTram_descTramite).append (" AS DESC_TRAMITE").append(",");
			strSql.append(W83bActasBD.hisTram_descFase).append (" AS DESC_FASE").append(",");
		}
		else{
			strSql.append(W83bActasBD.hisTram_deseTramite).append (" AS DESC_TRAMITE").append(",");
			strSql.append(W83bActasBD.hisTram_deseFase).append (" AS DESC_FASE").append(",");
		}
		strSql.append(W83bActasBD.hisTram_usuAlta).append(", ");
		strSql.append(W83bActasBD.hisTram_usuMod).append(", ");
		strSql.append(W83bActasBD.hisTram_nRegSalida);

		
		strSql.append(" FROM ").append(W83bActasBD.vista_historial_tramitacion);
		
		strSql.append(" WHERE ").append(W83bActasBD.codTerritorio).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.ano_acta).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.num_acta).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.version_acta).append(" = ?");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getNumActaTerritorio());		
		params.add(param.getNumActaAno());
		params.add(param.getNumActa());
		params.add(param.getVersion());
		//crear un nuevo bean
		strSql.append(" ORDER BY ").append(W83bActasBD.hisTram_codFase).append(" ASC ,").append(W83bActasBD.hisTram_codTramite).append(" ASC");
		List listaTramites = W83bDataBase.executeQuery(strSql.toString(),params,W83bTramiteActaBean.class,null, null);
		
		param.setListaTramitacion(listaTramites);
		return param;
	}
	public W83bActasBean obtenerIncidenciasActas(W83bActasBean param)throws Exception {
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.inc_territ).append("||'/'||");
		strSql.append(W83bActasBD.inc_anyo).append("||'/'||");
		strSql.append("DECODE (LENGTH (TO_CHAR (").append(W83bActasBD.inc_num).append(")),");
		strSql.append("1, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append("2, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append("3, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append("4, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append("5, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append(" TO_CHAR (").append(W83bActasBD.inc_num).append(")) ");
		
		strSql.append(" as ");
		strSql.append(W83bActasBD.inc_num).append(", to_number(");
		strSql.append(W83bActasBD.inc_territ).append("||");
		strSql.append(W83bActasBD.inc_anyo).append("||");
		strSql.append("DECODE (LENGTH (TO_CHAR (").append(W83bActasBD.inc_num).append(")),");
		strSql.append("1, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append("2, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append("3, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append("4, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append("5, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append(" TO_CHAR (").append(W83bActasBD.inc_num).append(")) ");
		
		strSql.append(") as ");
		strSql.append(W83bActasBD.inc_num).append("_int, ");
		strSql.append(W83bActasBD.inc_dni).append(",");
		strSql.append(W83bActasBD.inc_tipoIncidencia).append(", TO_CHAR (");
		strSql.append(W83bActasBD.inc_fechaEntrada).append (",?) F_ENTRADA_061,");
		strSql.append(W83bActasBD.inc_fechaEntrada).append(" FECHA,");
		if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO))
		{
			strSql.append(W83bActasBD.inc_desc).append(" AS DESCRIPCION ");
		}
		else{
			strSql.append(W83bActasBD.inc_dese).append(" AS DESCRIPCION ");
		}
		strSql.append(" FROM ").append(W83bActasBD.incidencias_Synonym).append(",");
		strSql.append(W83bActasBD.incidencias_descripcion_Synonym);
		strSql.append(" WHERE ").append(W83bActasBD.inc_numActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.inc_anyoActa).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.inc_territ).append(" = ?");
		
		strSql.append(" AND ");
		strSql.append(W83bActasBD.inc_tipoIncidencia).append("=");
		strSql.append(W83bActasBD.inc_tipoIncidenciaDesc);
		strSql.append(" AND ");
		strSql.append(W83bActasBD.inc_anoActaParcial).append(" is null");		
//		strSql.append(" ORDER BY ").append(W83bActasBD.inc_num).append("_int asc");
		
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());	
		
		strSql.append(" UNION SELECT ");
		strSql.append(W83bActasBD.inc_territ).append("||'/'||");
		strSql.append(W83bActasBD.inc_anyo).append("||'/'||");
		strSql.append("DECODE (LENGTH (TO_CHAR (").append(W83bActasBD.inc_num).append(")),");
		strSql.append("1, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append("2, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append("3, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append("4, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append("5, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append(" TO_CHAR (").append(W83bActasBD.inc_num).append(")) ");
		
		strSql.append(" as ");
		strSql.append(W83bActasBD.inc_num).append(", to_number(");
		strSql.append(W83bActasBD.inc_territ).append("||");
		strSql.append(W83bActasBD.inc_anyo).append("||");
		strSql.append("DECODE (LENGTH (TO_CHAR (").append(W83bActasBD.inc_num).append(")),");
		strSql.append("1, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append("2, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append("3, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append("4, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append("5, '00000'|| TO_CHAR (").append(W83bActasBD.inc_num).append("),");
		strSql.append(" TO_CHAR (").append(W83bActasBD.inc_num).append(")) ");
		
		strSql.append(") as ");
		strSql.append(W83bActasBD.inc_num).append("_int, ");
		strSql.append(W83bActasBD.inc_dni).append(",");
		strSql.append(W83bActasBD.inc_tipoIncidencia).append(", TO_CHAR (");
		strSql.append(W83bActasBD.inc_fechaEntrada).append (",?) F_ENTRADA_061,");
		strSql.append(W83bActasBD.inc_fechaEntrada).append(" FECHA,");
		if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO))
		{
			strSql.append(W83bActasBD.inc_desc).append(" AS DESCRIPCION ");
		}
		else{
			strSql.append(W83bActasBD.inc_dese).append(" AS DESCRIPCION ");
		}
		strSql.append(" FROM ").append(W83bActasBD.incidencias_Synonym).append(",");
		strSql.append(W83bActasBD.incidencias_descripcion_Synonym);
		strSql.append(" WHERE ").append(W83bActasBD.inc_nActaParcial).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.inc_anoActaParcial).append(" = ?");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.inc_territ).append(" = ?");
		
		strSql.append(" AND ");
		strSql.append(W83bActasBD.inc_tipoIncidencia).append("=");
		strSql.append(W83bActasBD.inc_tipoIncidenciaDesc);
		strSql.append(" ORDER BY ").append(W83bActasBD.inc_num).append("_int asc");
		
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		params.add(param.getNumActa());
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());	
		
		//crear un nuevo bean
		List listaIncidencias = W83bDataBase.executeQuery(strSql.toString(),params,W83bIncidenciaActaBean.class,null, null);
		
		param.setListaIncidencias(listaIncidencias);
		return param;
	}
	public void anyadirHistorialTramitacionFechaModificacion(W83bActasBean param,String fechaRegistro) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("INSERT INTO ");
		strSql.append(W83bActasBD.historial_tramitacion_Synonym);
		
		strSql.append("(");
		strSql.append(W83bActasBD.hisTram_numActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_anyoActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_territActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_versionActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_tram);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fase);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fechaActualizacion);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_usuario);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_usuarioModificacion);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fechaModificacion);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fechaTram);
		strSql.append(")");
		strSql.append(" VALUES (?,?,?,?,?,?,to_date(?,'"+W83bDateUtil.ES_PATTERN_HORA_INSERT+"'),?,?,");
		strSql.append("to_date(?,'"+W83bDateUtil.ES_PATTERN_HORA_INSERT+"'),");
		strSql.append("to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO+"'))");
		
		params.add(new Integer(param.getNumActa()));
		params.add(new Integer(param.getNumActaAno()));
		params.add(param.getNumActaTerritorio());
		params.add(param.getVersion());
		params.add(new Integer(param.getTramite()));
		params.add(new Integer(param.getFase()));
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN_HORA);
		params.add(sdf.format(new Date()));
		params.add(param.getUsuarioBean().getIdUsuario());
		params.add(param.getUsuarioBean().getIdUsuario());
		params.add(sdf.format(new Date()));
		if(StringUtils.isNotEmpty(fechaRegistro)){
			params.add(fechaRegistro);
		}
		else{
			SimpleDateFormat hoy =new SimpleDateFormat(W83bClsConstantes.FORMATO_FECHA_CASTELLANO_PARSER);
			params.add(hoy.format(new Date()));
		}
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
	}
	public void anyadirHistorialTramitacion(W83bActasBean param,String fechaRegistro) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("INSERT INTO ");
		strSql.append(W83bActasBD.historial_tramitacion_Synonym);
		
		strSql.append("(");
		strSql.append(W83bActasBD.hisTram_numActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_anyoActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_territActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_versionActa);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_tram);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fase);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fechaActualizacion);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_usuario);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_usuarioModificacion);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fechaModificacion);
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_fechaTram);
		strSql.append(")");
		strSql.append(" VALUES (?,?,?,?,?,?,to_date(?,'"+W83bDateUtil.ES_PATTERN_HORA_INSERT+"'),?,?,");
		strSql.append("?,");
//		to_date(?,'"+W83bDateUtil.ES_PATTERN_HORA_INSERT+"'),
		strSql.append("to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO+"'))");
		
		params.add(new Integer(param.getNumActa()));
		params.add(new Integer(param.getNumActaAno()));
		params.add(param.getNumActaTerritorio());
		params.add(param.getVersion());
		params.add(new Integer(param.getTramite()));
		params.add(new Integer(param.getFase()));
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN_HORA);
		params.add(sdf.format(new Date()));
		params.add(param.getUsuarioBean().getIdUsuario());
		//params.add(param.getUsuarioBean().getIdUsuario());
		params.add(W83bClsConstantes.NULL_STRING);
		params.add(W83bClsConstantes.NULL_DATE);
		//params.add(sdf.format(new Date()));
		if(StringUtils.isNotEmpty(fechaRegistro)){
			params.add(fechaRegistro);
		}
		else{
			SimpleDateFormat hoy =new SimpleDateFormat(W83bClsConstantes.FORMATO_FECHA_CASTELLANO_PARSER);
			params.add(hoy.format(new Date()));
		}
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
	}
	public void editarHistorialTramitacion(W83bActasBean param,String fechaRegistro) throws Exception {
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("UPDATE ") ;
		strSql.append(W83bActasBD.historial_tramitacion_Synonym);
		strSql.append(" SET ");
		strSql.append(W83bActasBD.hisTram_fechaModificacion);
		strSql.append(" = to_date(?,'"+W83bClsConstantes.FORMATO_FECHA_COMPLETA_CASTELLANO+"')");
		strSql.append(",");
		strSql.append(W83bActasBD.hisTram_usuarioModificacion);
		strSql.append(" = ?");
		strSql.append(" WHERE ").append(W83bActasBD.hisTram_territActa).append(" = ? ");
		strSql.append(" AND ").append(W83bActasBD.hisTram_anyoActa).append(" = ? ");
		strSql.append(" AND ").append(W83bActasBD.hisTram_numActa).append(" = ? ");
		strSql.append(" AND ").append(W83bActasBD.hisTram_versionActa).append(" = ? ");
		strSql.append(" AND ").append(W83bActasBD.hisTram_tram).append(" = ? ");
		strSql.append(" AND ").append(W83bActasBD.hisTram_fase).append(" = ? ");
		
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN_HORA);
		params.add(sdf.format(new Date()));
		params.add(param.getUsuarioBean().getIdUsuario());
		
		params.add(param.getNumActaTerritorio());
		params.add(new Integer(param.getNumActaAno()));
		params.add(new Integer(param.getNumActa()));
		params.add(param.getVersion());
		params.add(new Integer(param.getTramite()));
		params.add(new Integer(param.getFase()));
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
		
	}
	public void insertarHistorialActas(W83bActasBean acta,String texto)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("INSERT INTO ");
		strSql.append(W83bActasBD.historial_Synonym);
		strSql.append("(");
		strSql.append(W83bActasBD.his_acta);
		strSql.append(",");
		strSql.append(W83bActasBD.his_anyoActa);
		strSql.append(",");
		strSql.append(W83bActasBD.his_territ);
		strSql.append(",");
		strSql.append(W83bActasBD.his_factu);
		strSql.append(",");
		strSql.append(W83bActasBD.his_usu);
		strSql.append(",");
		strSql.append(W83bActasBD.his_desc);
		strSql.append(",");
		strSql.append(W83bActasBD.his_dese);
		strSql.append(")");
		strSql.append(" VALUES (?,?,?,to_date(?,'"+W83bDateUtil.ES_PATTERN+"'),?,?,?)");
		
		params.add(new Integer(acta.getNumActa()));
		params.add(new Integer(acta.getNumActaAno()));
		params.add(acta.getNumActaTerritorio());
		SimpleDateFormat sdf =new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
		params.add(sdf.format(new Date()));
		params.add(acta.getUsuarioBean().getIdUsuario());
		params.add(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", texto, W83bClsConstantes.CONSTANTE_CASTELLANO));
		params.add(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun", texto, W83bClsConstantes.CONSTANTE_EUSKARA));
		W83bDataBase.executeTableMovement(strSql.toString(), params,acta.getUsuarioBean());
		
	}
	public boolean borrarActaLogico(String param,String motivo,String fecha,W83bUsuarioXLNetsBean usuarioBean,String idioma,String version) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codActa=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bActasBD.actasTable);
		strSql.append(" SET ");
		strSql.append(W83bActasBD.fechaBaja);
		strSql.append(" = to_Date(?,?), ");
		strSql.append(W83bActasBD.codMotivosBaja);
		strSql.append(" = ? ");
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.numActa);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.anyoActa);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.codTerritActa);
		strSql.append(" = ? ");
		params.add(fecha);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		params.add(motivo);		
		params.add(new String(codActa[3]));		
		params.add(new Integer(codActa[2]));
		params.add(codActa[1]);
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
	    
		return true;
	}
	public boolean borrarEscrutinios(String param,W83bUsuarioXLNetsBean usuarioBean,String version,boolean conVersion) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codActa=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bEscrutiniosBD.escrutTable);
		strSql.append(" WHERE ");
		strSql.append(W83bEscrutiniosBD.acta);
		strSql.append(" = ? AND ");
		strSql.append(W83bEscrutiniosBD.anyoActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bEscrutiniosBD.territorioActa);
		strSql.append(" = ? ");
		params.add(codActa[3]);		
		params.add(codActa[2]);
		params.add(codActa[1]);
		if(conVersion){
			strSql.append(" AND ");
			strSql.append(W83bEscrutiniosBD.versionActa);
			strSql.append(" = ? ");
			params.add(version);
		}
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
	    
		return true;
	}
	public boolean borrarEscrutiniosColegio(W83bActasBean acta,String colegio) throws Exception {
		// TODO Auto-generated method stub
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bEscrutiniosBD.escrutTable);
		strSql.append(" WHERE ");
		strSql.append(W83bEscrutiniosBD.acta);
		strSql.append(" = ? AND ");
		strSql.append(W83bEscrutiniosBD.anyoActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bEscrutiniosBD.territorioActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bEscrutiniosBD.versionActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bEscrutiniosBD.codigoColegio);
		strSql.append(" = ? ");
		params.add(acta.getNumActa());		
		params.add(acta.getNumActaAno());
		params.add(acta.getNumActaTerritorio());
		params.add(acta.getVersion());
		params.add(colegio);
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,acta.getUsuarioBean());

		}
		catch (SQLException e)
		{
			return false;
		}
	    
		return true;
	}
	public boolean borrarDiferencias(String param,W83bUsuarioXLNetsBean usuarioBean,String version,boolean conVersion) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codActa=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bDiferenciasBD.difTable);
		strSql.append(" WHERE ");
		strSql.append(W83bDiferenciasBD.acta);
		strSql.append(" = ? AND ");
		strSql.append(W83bDiferenciasBD.anyoActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bDiferenciasBD.territorioActa);
		strSql.append(" = ? ");
		params.add(codActa[3]);		
		params.add(codActa[2]);
		params.add(codActa[1]);
		if(conVersion){
			strSql.append(" AND ");
			strSql.append(W83bDiferenciasBD.versionActa);
			strSql.append(" = ?");
			params.add(version);
		}
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
	    
		return true;
	}
	public boolean borrarDiferenciasColegio(W83bActasBean acta,String colegio) throws Exception {
		// TODO Auto-generated method stub
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bDiferenciasBD.difTable);
		strSql.append(" WHERE ");
		strSql.append(W83bDiferenciasBD.acta);
		strSql.append(" = ? AND ");
		strSql.append(W83bDiferenciasBD.anyoActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bDiferenciasBD.territorioActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bDiferenciasBD.versionActa);
		strSql.append(" =? AND ");
		strSql.append(W83bDiferenciasBD.codigoColegio);
		strSql.append(" = ?");
		params.add(acta.getNumActa());		
		params.add(acta.getNumActaAno());
		params.add(acta.getNumActaTerritorio());
		params.add(acta.getVersion());
		params.add(colegio);
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,acta.getUsuarioBean());

		}
		catch (SQLException e)
		{
			return false;
		}
	    
		return true;
	}
	public boolean borrarDelegados(String param,W83bUsuarioXLNetsBean usuarioBean,String version,boolean conVersion) throws Exception {
		// TODO Auto-generated method stub
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(usuarioBean.getIdUsuario());
		
		String [] codActa=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bDelegadosBD.delegadosTable);
		strSql.append(" WHERE ");
		strSql.append(W83bDelegadosBD.acta);
		strSql.append(" = ? AND ");
		strSql.append(W83bDelegadosBD.anyoActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bDelegadosBD.territorioActa);
		strSql.append(" = ? ");
		params.add(codActa[3]);		
		params.add(codActa[2]);
		params.add(codActa[1]);
		if(conVersion){
			strSql.append(" AND ");
			strSql.append(W83bDelegadosBD.versionActa);
			strSql.append(" = ?");
			params.add(version);
		}
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);
			//TERMINAR USUARIO
			W83bDataBase.terminarUsuarioAuditor();

		}
		catch (SQLException e)
		{
			//TERMINAR USUARIO
			W83bDataBase.terminarUsuarioAuditor();
			return false;
		}
	    
		return true;
	}
	public boolean borrarDelegadoConcreto(W83bActasBean param,W83bListaDelegadosBean delegado,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(usuarioBean.getIdUsuario());
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bDelegadosBD.delegadosTable);
		strSql.append(" WHERE ");
		strSql.append(W83bDelegadosBD.acta);
		strSql.append(" = ? AND ");
		strSql.append(W83bDelegadosBD.anyoActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bDelegadosBD.territorioActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bDelegadosBD.dni);
		strSql.append(" = ? AND ");
		strSql.append(W83bDelegadosBD.versionActa);
		strSql.append(" = ?");
		params.add(param.getNumActa());		
		params.add(param.getNumActaAno());
		params.add(param.getNumActaTerritorio());
		params.add(delegado.getDni());
		params.add(param.getVersion());
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);
			//TERMINAR USUARIO
			W83bDataBase.terminarUsuarioAuditor();

		}
		catch (SQLException e)
		{
			//TERMINAR USUARIO
			W83bDataBase.terminarUsuarioAuditor();
			return false;
		}
	    
		return true;
	}
	
	public boolean borrarFisicoDelegados(W83bActasBean acta) throws Exception {
		// TODO Auto-generated method stub
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(acta.getUsuarioBean().getIdUsuario());
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("DELETE FROM ");
		strSql.append(W83bDelegadosBD.delegadosTable);
		strSql.append(" WHERE ");
		strSql.append(W83bDelegadosBD.acta);
		strSql.append(" = ? AND ");
		strSql.append(W83bDelegadosBD.anyoActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bDelegadosBD.territorioActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bDelegadosBD.versionActa);
		strSql.append(" = ?");
		params.add(acta.getNumActa());		
		params.add(acta.getNumActaAno());
		params.add(acta.getNumActaTerritorio());
		params.add(acta.getVersion());
		
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,acta.getUsuarioBean());
			//TERMINAR USUARIO
			W83bDataBase.terminarUsuarioAuditor();
			
		}
		catch (SQLException e)
		{
			//TERMINAR USUARIO
			W83bDataBase.terminarUsuarioAuditor();
			return false;
		}
		
		return true;
	}
	public boolean borrarDelegados(W83bActasBean acta) throws Exception {
		// TODO Auto-generated method stub
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		//IDENTIFICAR USUARIO
		W83bDataBase.identificarUsuarioAuditor(acta.getUsuarioBean().getIdUsuario());
		
	    
		strSql.append("UPDATE ");
		strSql.append(W83bDelegadosBD.delegadosTable).append(" SET ");
		strSql.append(W83bDelegadosBD.fechaBaja).append("=?");
		strSql.append(" WHERE ");
		strSql.append(W83bDelegadosBD.acta);
		strSql.append(" = ? AND ");
		strSql.append(W83bDelegadosBD.anyoActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bDelegadosBD.territorioActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bDelegadosBD.versionActa);
		strSql.append(" = ? ");
		SimpleDateFormat sdf=new SimpleDateFormat(W83bDateUtil.ES_PATTERN);
		params.add(sdf.format(new Date()));
		
		params.add(acta.getNumActa());		
		params.add(acta.getNumActaAno());
		params.add(acta.getNumActaTerritorio());
		params.add(acta.getVersion());
		
		//TERMINAR USUARIO
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,acta.getUsuarioBean());
		W83bDataBase.terminarUsuarioAuditor();

		}
		catch (SQLException e)
		{
			return false;
		}
	    
		return true;
	}
	public boolean borrarPapeletas(String param,W83bUsuarioXLNetsBean usuarioBean,String version,boolean conVersion) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codActa=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bPapeletasBD.papeletasTable);
		strSql.append(" WHERE ");
		strSql.append(W83bPapeletasBD.acta);
		strSql.append(" = ? AND ");
		strSql.append(W83bPapeletasBD.anyoActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bPapeletasBD.territorioActa);
		strSql.append(" = ?");
		params.add(codActa[3]);		
		params.add(codActa[2]);
		params.add(codActa[1]);
		if(conVersion){
			strSql.append(" AND ");
			strSql.append(W83bPapeletasBD.versionActa);
			strSql.append(" = ? ");
			params.add(version);
		}
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
	    
		return true;
	}
	public boolean borrarDocsAdjuntos(String param,W83bUsuarioXLNetsBean usuarioBean,String version,boolean conVersion) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codActa=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bActasBD.actas_docsTable);
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.doc_numActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bActasBD.doc_anyoActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bActasBD.doc_territActa);
		strSql.append(" = ?");
		params.add(codActa[3]);		
		params.add(codActa[2]);
		params.add(codActa[1]);
		if(conVersion){
			strSql.append(" AND ");
			strSql.append(W83bActasBD.doc_versionActa);
			strSql.append(" = ? ");
			params.add(version);
		}
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
	    
		return true;
	}
	public boolean borrarAuditoriaImpugnaciones(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codActa=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("DELETE FROM ");
		strSql.append(W83bImpugnacionesBD.impugncion_historial_Synonym);
		strSql.append(" WHERE ");
		strSql.append(W83bImpugnacionesBD.n_impug_073);
		strSql.append(" = ? AND ");
		strSql.append(W83bImpugnacionesBD.ano_impug_073);
		strSql.append(" = ? AND ");
		strSql.append(W83bImpugnacionesBD.c_territ_073);
		strSql.append(" = ? ");
		params.add(codActa[3]);		
		params.add(codActa[2]);
		params.add(codActa[1]);
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);
			
		}
		catch (SQLException e)
		{
			return false;
		}
		
		return true;
	}
	public boolean borrarHistorialImpugnaciones(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codActa=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("DELETE FROM ");
		strSql.append(W83bImpugnacionesBD.tramitesImpugnacion);
		strSql.append(" WHERE ");
		strSql.append(W83bImpugnacionesBD.numImpugnacionTram);
		strSql.append(" = ? AND ");
		strSql.append(W83bImpugnacionesBD.anyoImpugnacionTram);
		strSql.append(" = ? AND ");
		strSql.append(W83bImpugnacionesBD.codTerritorioImpugnacionTram);
		strSql.append(" = ? ");
		params.add(codActa[3]);		
		params.add(codActa[2]);
		params.add(codActa[1]);
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);
			
		}
		catch (SQLException e)
		{
			return false;
		}
		
		return true;
	}
	public boolean borrarImpugnaciones(String param,W83bUsuarioXLNetsBean usuarioBean,String version) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codActa=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bImpugnacionesBD.tableImpugnaciones);
		strSql.append(" WHERE ");
		strSql.append(W83bImpugnacionesBD.n_acta);
		strSql.append(" = ? AND ");
		strSql.append(W83bImpugnacionesBD.ano_acta);
		strSql.append(" = ? AND ");
		strSql.append(W83bImpugnacionesBD.c_territ);
		strSql.append(" = ? AND ");
		strSql.append(W83bImpugnacionesBD.version);
		strSql.append(" = ? ");
		params.add(codActa[3]);		
		params.add(codActa[2]);
		params.add(codActa[1]);
		params.add(version);
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
	    
		return true;
	}
	public List buscarImpugnacion(W83bActasBean bean) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append(" SELECT ");
		strSql.append(W83bImpugnacionesBD.n_impug).append(", ");
		strSql.append(W83bImpugnacionesBD.ano_impug);
		
		strSql.append(" FROM ").append(W83bImpugnacionesBD.tableImpugnaciones);
		strSql.append(" WHERE ");
		strSql.append(W83bImpugnacionesBD.n_acta);
		strSql.append(" = ? AND ");
		strSql.append(W83bImpugnacionesBD.ano_acta);
		strSql.append(" = ? AND ");
		strSql.append(W83bImpugnacionesBD.c_territ);
		strSql.append(" = ? AND ");
		strSql.append(W83bImpugnacionesBD.version);
		strSql.append(" = ? ");
		params.add(bean.getNumActa().split("/")[2]);		
		params.add(bean.getNumActa().split("/")[1]);
		params.add(bean.getCodTerritorioActa());
		params.add(bean.getVersion());
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,bean.getUsuarioBean());
						
		return lista;
	}
	public List buscarIncidencias(W83bActasBean bean) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append(" SELECT ");
		strSql.append(W83bIncidenciasBD.N_INCID_061).append(", ");
		strSql.append(W83bIncidenciasBD.ANO_INCID_061);
		
		strSql.append(" FROM ").append(W83bIncidenciasBD.incidenciasSinonimo);
		strSql.append(" WHERE ");
		strSql.append(W83bIncidenciasBD.C_TERRIT_061);
		strSql.append(" = ? AND ((");
		strSql.append(W83bIncidenciasBD.N_ACTA_061);
		strSql.append(" = ? AND ");
		strSql.append(W83bIncidenciasBD.ANO_ACTA_061);
		strSql.append(" = ?)");
		strSql.append(" or (");
		strSql.append(W83bIncidenciasBD.N_ACTA_PARCIAL_061);
		strSql.append(" = ? AND ");
		strSql.append(W83bIncidenciasBD.ANO_ACTA_PARCIAL_061);
		strSql.append(" = ?))");
		params.add(bean.getCodTerritorioActa());
		params.add(bean.getNumActa().split("/")[2]);		
		params.add(bean.getNumActa().split("/")[1]);
		params.add(bean.getNumActa().split("/")[2]);		
		params.add(bean.getNumActa().split("/")[1]);
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,bean.getUsuarioBean());
		
		return lista;
	}
	public boolean borrarHistorialActa(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codActa=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("DELETE FROM ");
		strSql.append(W83bActasBD.historial_Synonym);
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.his_acta);
		strSql.append(" = ? AND ");
		strSql.append(W83bActasBD.his_anyoActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bActasBD.his_territ);
//		strSql.append(" = ? AND ");
//		strSql.append(W83bActasBD.hisTram_versionActa);
		strSql.append(" = ? ");
		params.add(codActa[3]);		
		params.add(codActa[2]);
		params.add(codActa[1]);
//		params.add(version);
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);
			
		}
		catch (SQLException e)
		{
			return false;
		}
		
		return true;
	}
	public boolean borrarHistorialTramitacion(String param,W83bUsuarioXLNetsBean usuarioBean,String version,boolean conVersion) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codActa=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bActasBD.historial_tramitacion_Synonym);
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.hisTram_numActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bActasBD.hisTram_anyoActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bActasBD.hisTram_territActa);
		strSql.append(" = ? ");
		params.add(codActa[3]);		
		params.add(codActa[2]);
		params.add(codActa[1]);
		if(conVersion){
			strSql.append(" AND ");
			strSql.append(W83bActasBD.hisTram_versionActa);
			strSql.append(" = ? ");
			params.add(version);
		}
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			return false;
		}
	    
		return true;
	}
	
	public boolean buscarHistorialTramitacion(W83bUsuarioXLNetsBean usuarioBean,String version, W83bActasBean bean) throws Exception {
		// TODO Auto-generated method stub
						
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("SELECT * FROM ");
		strSql.append(W83bActasBD.historial_tramitacion_Synonym);
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.hisTram_numActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bActasBD.hisTram_anyoActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bActasBD.hisTram_territActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bActasBD.hisTram_versionActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bActasBD.hisTram_tram);
		strSql.append(" = ? AND ");
		strSql.append(W83bActasBD.hisTram_fase);
		strSql.append(" = ? ");
		params.add(bean.getNumActa());		
		params.add(bean.getNumActaAno());
		params.add(bean.getTerritorioActaTotal());
		params.add(version);
		params.add(bean.getTramite());
		params.add(bean.getFase());
		
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,usuarioBean);
		
		if(listaActas.size()>0){
			return true;
		}
		
		return false;	
	}
	public boolean borrarActaFisico(String param,W83bUsuarioXLNetsBean usuarioBean,String version,boolean conVersion) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codActa=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bActasBD.actasTable);
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.numActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bActasBD.anyoActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bActasBD.codTerritActa);
		strSql.append(" = ?");
		params.add(codActa[3]);		
		params.add(codActa[2]);
		params.add(codActa[1]);
		if(conVersion){
			strSql.append(" AND ");
			strSql.append(W83bActasBD.versionActa);
			strSql.append(" = ? ");
			params.add(version);
		}
		W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		return true;
	}
	public String maxCodActa(String anyo, String territorio)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT NVL(MAX(");
		strSql.append(W83bActasBD.numActa);
		
		strSql.append("),0) FROM ").append(W83bActasBD.actasTable);
		strSql.append(" WHERE ").append(W83bActasBD.anyoActa).append("=?");
		strSql.append(" AND  ").append(W83bActasBD.codTerritActa).append("=?");
		params.add(anyo);
		params.add(territorio);
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		return listaActas.get(0).toString(); 		
	}
	public String contarActas(String anyo, String territorio)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT COUNT(");
		strSql.append(W83bActasBD.numActa);
		
		strSql.append(") FROM ").append(W83bActasBD.actasTable);
		strSql.append(" WHERE ").append(W83bActasBD.anyoActa).append("=?");
		strSql.append(" AND  ").append(W83bActasBD.codTerritActa).append("=?");
		params.add(anyo);
		params.add(territorio);
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		return listaActas.get(0).toString(); 		
	}
	public boolean existeActa(String anyo, String territorio, String numActa) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.numActa);
		
		strSql.append(" FROM ").append(W83bActasBD.actasTable);
		
		strSql.append(" WHERE ").append(W83bActasBD.anyoActa).append("=?");
		strSql.append(" AND  ").append(W83bActasBD.codTerritActa).append("=?");		
		strSql.append(" AND  ").append(W83bActasBD.numActa).append("=?");	
		params.add(anyo);
		params.add(territorio);
		params.add(numActa);
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		if(listaActas.size()>0){
			return true;
		}
		
		return false;		
	}
	public String modificarPreaviso(W83bActasBean acta) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("UPDATE ");
		strSql.append(W83bPreavisosBD.preavisosTable).append(" SET ");
		strSql.append(W83bPreavisosBD.n_acta_037).append("=?,");
		strSql.append(W83bPreavisosBD.ano_acta_037).append("=?,");
		strSql.append(W83bPreavisosBD.f_elecc_037).append("= to_Date(?,'"+W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma())+"') ");
		
		strSql.append(" WHERE ").append(W83bPreavisosBD.ano_preaviso_037).append("=?");
		strSql.append(" AND  ").append(W83bPreavisosBD.c_territ_037).append("=?");		
		strSql.append(" AND  ").append(W83bPreavisosBD.n_preaviso_037).append("=?");	
		params.add(acta.getNumActa());
		params.add(acta.getNumActaAno());
		params.add(acta.getFechaEleccion());
		
		params.add(acta.getAnyoPreaviso());
		params.add(acta.getNumActaTerritorio());
		params.add(acta.getNumPreaviso());
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,acta.getUsuarioBean());
		return "";		
	}
	public String borrarActaPreaviso(String territ, String anyo, String num,W83bUsuarioXLNetsBean usuarioBean,String idioma) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("UPDATE ");
		strSql.append(W83bPreavisosBD.preavisosTable).append(" SET ");
		strSql.append(W83bPreavisosBD.n_acta_037).append("=?,");
		strSql.append(W83bPreavisosBD.ano_acta_037).append("=?,");
		strSql.append(W83bPreavisosBD.f_elecc_037).append("= to_Date(?,'"+W83bDateUtil.getInstance().devolverFormatoIdioma(idioma)+"')");
		
		strSql.append(" WHERE ").append(W83bPreavisosBD.ano_acta_037).append("=?");
		strSql.append(" AND  ").append(W83bPreavisosBD.c_territ_037).append("=?");		
		strSql.append(" AND  ").append(W83bPreavisosBD.n_acta_037).append("=?");	
		params.add(W83bClsConstantes.NULL_STRING);
		params.add(W83bClsConstantes.NULL_STRING);
		params.add(W83bClsConstantes.NULL_DATE);
		
		params.add(anyo);
		params.add(territ);
		params.add(num);
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);
		return "";		
	}
	public void borrarDocsActas(W83bActasBean param) throws Exception {
		if (param.getListaDocsBorrados()!=null && param.getListaDocsBorrados().size()>0)
		{
			StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			List params = new ArrayList();
			
			strSql.append("DELETE FROM ");
			strSql.append(W83bActasBD.actas_docsTable);
			strSql.append(" WHERE ");
			strSql.append(W83bActasBD.doc_id).append(" = ?");
			
			for (int i=0;i< param.getListaDocsBorrados().size();i++)
			{
				String idDoc= (String)param.getListaDocsBorrados().get(i);
				params.add(idDoc);
				W83bDataBase.executeTableMovement(strSql.toString(), params,param.getUsuarioBean());
				params.clear();
			}
		}
	}
	public List buscarSindicatosActas(W83bActasBean acta)throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append(" SELECT  ");
		if (acta.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO))
		{
			strSql.append(W83bActasBD.det_colDesc).append(" ").append(W83bActasBD.det_colDes).append(",");
			strSql.append(W83bActasBD.det_sindDesc).append(" ").append(W83bActasBD.det_sindDes).append(",");
		}
		else{
			strSql.append(W83bActasBD.det_colDese).append(" ").append(W83bActasBD.det_colDes).append(",");
			strSql.append(W83bActasBD.det_sindDese).append(" ").append(W83bActasBD.det_sindDes).append(",");
		}
		strSql.append(W83bActasBD.det_delHombres).append(",");
		strSql.append(W83bActasBD.det_numVotos).append(",");
		strSql.append(W83bActasBD.det_delMujeres);
		
		strSql.append(" FROM ").append(W83bActasBD.actas_sindicatosView);
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.territ).append("=? AND ");
		strSql.append(W83bActasBD.det_anoActa).append("=? AND ");
		strSql.append(W83bActasBD.num_acta).append("=? AND ");
		strSql.append(W83bActasBD.version_acta).append("=?");
		params.add(acta.getNumActaTerritorio());
		params.add(acta.getNumActaAno());
		params.add(acta.getNumActa());
		params.add(acta.getVersion());
		
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bListaSindicatosBean.class,acta.getUsuarioBean(), "EXCEL");
		
	}
	
	public W83bActasBean detalleActaImpugnacion(W83bActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT TACTAS.");
		strSql.append(W83bActasBD.numActa).append(", TACTAS.");
		strSql.append(W83bActasBD.anyoActa).append(", TACTAS.");
		strSql.append(W83bActasBD.codTerritActa).append(", TACTAS.");
		strSql.append(W83bActasBD.versionActa).append(", TACTAS.");
		strSql.append(W83bActasBD.observaciones).append(", ");
		strSql.append("TO_CHAR(").append(W83bActasBD.fechaEntrada).append(",?) AS ").append(W83bActasBD.fechaEntrada).append(" , ");

		strSql.append("TO_CHAR(").append(W83bActasBD.fechaBaja).append(",?) AS ").append(W83bActasBD.fechaBaja).append(" , TACTAS.");
		strSql.append(W83bActasBD.codCentro).append(", TCENTROS.");
		strSql.append(W83bCentroTrabajoVistaBD.codcentro).append(", TCENTROS.");
		strSql.append(W83bCentroTrabajoVistaBD.razonsocial).append(", TCENTROS.");
		strSql.append(W83bCentroTrabajoVistaBD.domicilio).append(", TIMPUG.");
		strSql.append(W83bImpugnacionesBD.n_impug).append(", TIMPUG.");
		strSql.append(W83bImpugnacionesBD.ano_impug).append(", TIMPUG.");
		strSql.append(W83bImpugnacionesBD.f_impug);
		
		strSql.append(" FROM ").append(W83bActasBD.actasTable).append(" TACTAS");
		strSql.append(", ").append(W83bCentroTrabajoVistaBD.nombreVista).append(" TCENTROS");
		strSql.append(", ").append(W83bImpugnacionesBD.tableImpugnaciones).append(" TIMPUG");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		strSql.append(" WHERE TACTAS.");
		strSql.append(W83bActasBD.numActa).append(" = ? ");
		params.add(new Integer(param.getNumActa()));
		
		strSql.append(" AND TACTAS.").append(W83bActasBD.anyoActa).append(" = ? ");
		params.add(new Integer(param.getAnyoActaTotal()));
		
		strSql.append(" AND TACTAS.").append(W83bActasBD.codTerritActa).append(" = ? ");
		params.add(param.getTerritorioActaTotal());
		
		strSql.append(" AND TACTAS.").append(W83bActasBD.versionActa).append(" = ? ");
		params.add(new Integer(param.getVersion()));
		
		strSql.append(" AND TIMPUG.").append(W83bImpugnacionesBD.n_impug).append(" = ? ");
		params.add(new Integer(param.getNumImpug()));
		
		strSql.append(" AND TACTAS.").append(W83bActasBD.codCentro).append(" = TCENTROS.").append(W83bCentroTrabajoVistaBD.codcentro).append("(+)");
		strSql.append(" AND TACTAS.").append(W83bActasBD.numActa).append(" = TIMPUG.").append(W83bImpugnacionesBD.n_acta).append("(+)");
		strSql.append(" AND TACTAS.").append(W83bActasBD.anyoActa).append(" = TIMPUG.").append(W83bImpugnacionesBD.ano_acta).append("(+)");
		strSql.append(" AND TACTAS.").append(W83bActasBD.codTerritActa).append(" = TIMPUG.").append(W83bImpugnacionesBD.c_territ).append("(+)");
		
		
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bActasBean.class,param.getUsuarioBean(), "CONSULTAIMPG");
		
		return (W83bActasBean)listaActas.get(0);	
		
	}
	public boolean existeActaImpug(String anyo, String territorio, String numActa, String version) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.numActa);
		
		strSql.append(" FROM ").append(W83bActasBD.actasTable);
		
		strSql.append(" WHERE ").append(W83bActasBD.anyoActa).append("=?");
		strSql.append(" AND  ").append(W83bActasBD.codTerritActa).append("=?");		
		strSql.append(" AND  ").append(W83bActasBD.numActa).append("=?");
		strSql.append(" AND  ").append(W83bActasBD.versionActa).append("=?");
		params.add(new Integer(anyo));
		params.add(territorio);
		params.add(new Integer(numActa));
		params.add(new Integer(version));
		
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		if(listaActas.size()>0){
			return true;
		}
		
		return false;		
	}
	public W83bActasBean detalleActas(w83b.w83bBeans.W83bActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.versionActa).append(",");
		strSql.append(W83bActasBD.numActa).append(",");
		strSql.append(W83bActasBD.anyoActa).append(",");
		strSql.append(W83bActasBD.codTerritActa).append(",");
		strSql.append(W83bActasBD.numPreaviso).append(",");
		strSql.append(W83bActasBD.anyoPreaviso).append(",");
		strSql.append(W83bActasBD.codConvenio).append(",");
		if (param.getIdioma().equals(W83bClsConstantes.CONSTANTE_CASTELLANO)){
			strSql.append(W83bConveniosBD.descripcion).append(" AS DESC_CONVENIO,");
			strSql.append(W83bMotivosBajaActaBD.descMotivoCast).append(" AS DESC_BAJA,");
		}
		else{
			strSql.append(W83bConveniosBD.descripcion_eusk).append(" AS DESC_CONVENIO,");
			strSql.append(W83bMotivosBajaActaBD.descMotivoEusk).append(" AS DESC_BAJA,");
		}
		strSql.append(W83bActasBD.codCentro).append(",");
		strSql.append(W83bActasBD.codMotivosBaja).append(",TO_CHAR (");
		strSql.append(W83bActasBD.fechaEntrada).append(",?) F_ENTRA_016 ,TO_CHAR (");
		strSql.append(W83bActasBD.fechaEleccion).append(",?) F_ELECC_016,TO_CHAR (");
		strSql.append(W83bActasBD.fechaRegistro).append(",?) FREGLIB_016,TO_CHAR (");
		strSql.append(W83bActasBD.fecRegDefinitivo).append(",?) FREGDEF_016,TO_CHAR (");
		strSql.append(W83bActasBD.fechaComision).append(",?) F_COMIS_016,TO_CHAR (");
		strSql.append(W83bActasBD.fechaRequerimiento).append(",?) F_REQUE_016,TO_CHAR (");
		strSql.append(W83bActasBD.fechaSubsanacionReq).append(",?) F_SUBREQ_016,TO_CHAR (");
		strSql.append(W83bActasBD.fechaRetiradaComision).append(",?) F_RETCOM_016,TO_CHAR (");
		strSql.append(W83bActasBD.fechaPresentacionRegRegInterno).append(",?) F_PRRI_016,TO_CHAR (");
		strSql.append(W83bActasBD.fechaBaja).append(",?) F_BAJA_016,TO_CHAR (");
		strSql.append(W83bActasBD.fechaActualizacion).append(",?) FACTU_016,");
		
		strSql.append(W83bActasBD.totalElectores).append(",");
		strSql.append("(").append(W83bActasBD.nCandidatosHombre).append("+");
		strSql.append(W83bActasBD.nCandidatosMujer).append(") AS ").append(W83bActasBD.totalCandidatos).append(",");
		strSql.append(W83bActasBD.nCandidatosHombre).append(",");
		strSql.append(W83bActasBD.nCandidatosMujer).append(",");
		strSql.append(W83bActasBD.anyoTotalActa).append(",");
		strSql.append(W83bActasBD.numTotalActa).append(",");
		strSql.append(W83bActasBD.numRegistro).append(",");
		strSql.append(W83bActasBD.anyoRegDefinitivo).append(",");
		strSql.append(W83bActasBD.numRegDefinitivo).append(",");
		strSql.append(W83bActasBD.nElectoresHombre).append(",");
		strSql.append(W83bActasBD.nElectoresMujer).append(",");
		strSql.append(W83bActasBD.marcaComision).append(",");
		strSql.append(W83bActasBD.observaciones).append(",");
		strSql.append(W83bActasBD.usuarioActualizacion).append(",");
		strSql.append(W83bActasBD.inspeccionada).append(",");
		strSql.append(W83bActasBD.F_CONSTCOM_016).append(",");
		strSql.append(W83bActasBD.REMITE_016).append(",");
		strSql.append(W83bActasBD.validada).append(",");
		strSql.append(W83bCentroTrabajoBD.codNifCif).append(",");
		strSql.append(W83bCentroTrabajoBD.ncentroTrab).append(",");
		strSql.append(W83bCentroTrabajoBD.codPostalCentro).append(",");
		strSql.append(W83bCentroTrabajoBD.domicilioCentro).append(",");
		strSql.append(" PROVINCIA ,MUNICIPIO,");
		strSql.append(W83bCentroTrabajoBD.codProvinciaCentro).append(",");
		strSql.append(W83bCentroTrabajoBD.razonSocial).append(",");
		strSql.append(W83bCentroTrabajoBD.localidadCentro).append(",");
		strSql.append(W83bActasBD.maxDel).append(",");
		strSql.append(" DELEGADOS, TOTALESCR,TOTALDIF,DELEGADOSH,DELEGADOSM,ESCRHOMBRES0,ESCRHOMBRES1").append(",");
		strSql.append(" ESCRMUJERES0,ESCRMUJERES1,DIFHOMBRES0,DIFHOMBRES1,DIFMUJERES0,DIFMUJERES1, ");
		strSql.append(" MUN_001,PROVC_001 ");
		
	    strSql.append(" FROM TABLE (DETALLEACTADATOSC");
	    params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
	    strSql.append("(?,?,?,?))");
	    
	    params.add(param.getNumActa());//
	    params.add(param.getNumActaAno());
	    params.add(param.getNumActaTerritorio());
	    params.add(param.getVersion());
	    
		List listaActas = W83bDataBase.executeQuery(strSql.toString(),params,W83bActasBean.class,param.getUsuarioBean(), "DETALLE");
		
		return (W83bActasBean)listaActas.get(0);		
		
	}
	public String modificarPapeletas(W83bActasBean acta,String colegio) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("UPDATE "+W83bPapeletasBD.papeletasTable+" SET ");
		
		strSql.append(W83bPapeletasBD.validas).append("=?,");
		strSql.append(W83bPapeletasBD.nulas).append("=?,");
		strSql.append(W83bPapeletasBD.blancas).append("=?,");
		strSql.append(W83bPapeletasBD.electores).append("=?,");
		strSql.append(W83bPapeletasBD.votantes).append("=? WHERE ");
		strSql.append(W83bPapeletasBD.codColegio).append("=? AND ");
		strSql.append(W83bPapeletasBD.acta).append("=? AND ");
		strSql.append(W83bPapeletasBD.anyoActa).append("=? AND ");
		strSql.append(W83bPapeletasBD.versionActa).append("=? AND ");
		strSql.append(W83bPapeletasBD.territorioActa).append("=?");
		
		if(("0").equals(colegio)){
			
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getPapeletasValidasC1())){
				params.add(acta.getDatosEscrutinio().getPapeletasValidasC1());
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getPapeletasNulasC1())){
				params.add(acta.getDatosEscrutinio().getPapeletasNulasC1());
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getPapeletasBlancasC1())){
				params.add(acta.getDatosEscrutinio().getPapeletasBlancasC1());
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getElectoresTotalColegioC1())){
				params.add(acta.getDatosEscrutinio().getElectoresTotalColegioC1());
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getVotantesTotalColegioC1())){
				params.add(acta.getDatosEscrutinio().getVotantesTotalColegioC1());
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			params.add(acta.getColegios().getCod1());
		}
		else{
			
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getPapeletasValidasC2())){
				params.add(acta.getDatosEscrutinio().getPapeletasValidasC2());
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getPapeletasNulasC2())){
				params.add(acta.getDatosEscrutinio().getPapeletasNulasC2());
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getPapeletasBlancasC2())){
				params.add(acta.getDatosEscrutinio().getPapeletasBlancasC2());
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getElectoresTotalColegioC2())){
				params.add(acta.getDatosEscrutinio().getElectoresTotalColegioC2());
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			if(StringUtils.isNotEmpty(acta.getDatosEscrutinio().getVotantesTotalColegioC2())){
				params.add(acta.getDatosEscrutinio().getVotantesTotalColegioC2());
			}
			else{
				params.add(W83bClsConstantes.NULL_INTEGER);
			}
			params.add(acta.getColegios().getCod2());
		}
		params.add(acta.getNumActa());
		params.add(acta.getNumActaAno());
		params.add(acta.getVersion());
		params.add(acta.getNumActaTerritorio());
		
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,acta.getUsuarioBean());
		return "0";
	}
	public String borrarPapeletasColegio(W83bActasBean acta,String colegio) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("DELETE FROM "+W83bPapeletasBD.papeletasTable+" WHERE ");
		
		strSql.append(W83bPapeletasBD.codColegio).append("=? AND ");
		strSql.append(W83bPapeletasBD.acta).append("=? AND ");
		strSql.append(W83bPapeletasBD.anyoActa).append("=? AND ");
		strSql.append(W83bPapeletasBD.versionActa).append("=? AND ");
		strSql.append(W83bPapeletasBD.territorioActa).append("=?");
		
		params.add(colegio);
		params.add(acta.getNumActa());
		params.add(acta.getNumActaAno());
		params.add(acta.getVersion());
		params.add(acta.getNumActaTerritorio());
		
		
		W83bDataBase.executeTableMovement(strSql.toString(), params,acta.getUsuarioBean());
		return "0";
	}
	public boolean borrarEscrutinio(W83bListaEscrutiniosBean escrutinio) throws Exception {
		// TODO Auto-generated method stub
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bEscrutiniosBD.escrutTable);
		strSql.append(" WHERE ");
		strSql.append(W83bEscrutiniosBD.acta);
		strSql.append(" = ? AND ");
		strSql.append(W83bEscrutiniosBD.anyoActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bEscrutiniosBD.territorioActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bEscrutiniosBD.versionActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bEscrutiniosBD.codSind);
		strSql.append(" = ? AND ");
		strSql.append(W83bEscrutiniosBD.codigoColegio);
		strSql.append(" = ? ");
		
		params.add(escrutinio.getActa());		
		params.add(escrutinio.getAnyoActa());
		params.add(escrutinio.getTerritorioActa());
		params.add(escrutinio.getVersionActa());
		params.add(escrutinio.getSindicato());
		params.add(escrutinio.getCodColegio());
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,escrutinio.getUsuarioBean());

		}
		catch (SQLException e)
		{
			return false;
		}
	    
		return true;
	}
	public boolean borrarDiferencia(W83bListaDiferenciasBean diferencia) throws Exception {
		// TODO Auto-generated method stub
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("DELETE FROM ");
		strSql.append(W83bDiferenciasBD.difTable);
		strSql.append(" WHERE ");
		strSql.append(W83bDiferenciasBD.acta);
		strSql.append(" = ? AND ");
		strSql.append(W83bDiferenciasBD.anyoActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bDiferenciasBD.territorioActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bDiferenciasBD.versionActa);
		strSql.append(" = ? AND ");
		strSql.append(W83bDiferenciasBD.codSind);
		strSql.append(" = ? AND ");
		strSql.append(W83bDiferenciasBD.codigoColegio);
		strSql.append(" = ? ");
		
		params.add(diferencia.getActa());		
		params.add(diferencia.getAnyoActa());
		params.add(diferencia.getTerritorioActa());
		params.add(diferencia.getVersionActa());
		params.add(diferencia.getSindicato());
		params.add(diferencia.getCodColegio());
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,diferencia.getUsuarioBean());

		}
		catch (SQLException e)
		{
			return false;
		}
	    
		return true;
	}
	public String buscarActaPorCentroTrabajo(W83bCentroTrabajoBean centro) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.numActa);
		strSql.append(" FROM ").append(W83bActasBD.actasTable).append(" ACT WHERE ");
		strSql.append(W83bActasBD.codCentro).append("=?");;
		strSql.append(" AND ").append(W83bActasBD.fecRegDefinitivo).append(" IS NOT NULL");
		strSql.append(" AND ").append(W83bActasBD.numRegDefinitivo).append(" IS NOT NULL");
		strSql.append(" AND ").append(W83bActasBD.fechaBaja).append(" IS NULL");
		strSql.append(" AND ").append(W83bActasBD.versionActa).append(" =(SELECT MAX(");
		strSql.append(W83bActasBD.versionActa).append(") FROM ").append(W83bActasBD.actasTable).append(" ACTA WHERE ACTA.");
		strSql.append(W83bActasBD.numActa).append("=ACT.").append(W83bActasBD.numActa).append(" AND ACTA.");
		strSql.append(W83bActasBD.anyoActa).append("=ACT.").append(W83bActasBD.anyoActa).append(" AND ACTA.");
		strSql.append(W83bActasBD.codTerritActa).append("=ACT.").append(W83bActasBD.codTerritActa).append(" AND ACT.");
		strSql.append(W83bActasBD.versionActa).append("=").append(W83bClsConstantes.CONSTANTE_VALIDADA).append(")");
		if(StringUtils.isNotEmpty(centro.getNumActa())){
			strSql.append(" AND (").append(W83bActasBD.numActa).append("<>? ");
			strSql.append(" OR ").append(W83bActasBD.anyoActa).append("<>? ");
			strSql.append(" OR ").append(W83bActasBD.codTerritActa).append("<>?) ");
		}
		
		params.add(centro.getCodCentroTrabajo());
		if(StringUtils.isNotEmpty(centro.getNumActa())){
			params.add(centro.getNumActa());
			params.add(centro.getAnyoActa());
			params.add(centro.getTerritorioActa());
		}
		List listaCentroTrabajo = W83bDataBase.executeQuery(strSql.toString(),params,centro.getUsuarioBean());
		if(!listaCentroTrabajo.isEmpty()){
			return ((BigDecimal)((HashMap)listaCentroTrabajo.get(0)).get("N_ACTA_016")).toString();
		}
		else 
			return "";
				
	}
	
	
	/**
	 * @param param
	 * @return
	 * @throws Exception
	 */
	public List validarIntervaloEleccionSindicalCtoTrabajo(String idCentroTrabajo,String idioma
			,String territorioActa, String anyoActa,String numActa) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT to_char(actas.");
		strSql.append(W83bActasBD.fechaEleccion);
		strSql.append(",?) as ").append(W83bActasBD.fechaEleccion);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(idioma));
		
		strSql.append(" FROM ").append(W83bActasBD.actasTable);
		strSql.append(" actas WHERE actas.").append(W83bActasBD.codCentro).append(" = ? ");
		params.add(idCentroTrabajo);
		strSql.append(" and actas.").append(W83bActasBD.fechaBaja).append(" is null ");

		if(StringUtils.isNotEmpty(territorioActa)
				&&StringUtils.isNotEmpty(anyoActa)
				&&StringUtils.isNotEmpty(numActa)
		){
			strSql.append(" AND NOT(actas.").append(W83bActasBD.codTerritActa).append(" = ?");
			params.add(territorioActa);
			strSql.append(" AND actas.").append(W83bActasBD.anyoActa).append(" = ?");
			params.add(new Integer(anyoActa));
			strSql.append(" AND actas.").append(W83bActasBD.numActa).append(" = ?)");
			params.add(new Integer(numActa));
			strSql.append(" AND NOT(actas.").append(W83bActasBD.anyoTotalActa).append(" = ?");
			params.add(new Integer(anyoActa));
			strSql.append(" AND actas.").append(W83bActasBD.numTotalActa).append(" = ?)");
			params.add(new Integer(numActa));
		}
		strSql.append(" AND actas.").append(W83bActasBD.fechaEleccion).append(" = (");
		strSql.append("SELECT max(actasTemp.");
		strSql.append(W83bActasBD.fechaEleccion);		
		strSql.append(") FROM ").append(W83bActasBD.actasTable);
		strSql.append(" actasTemp WHERE actasTemp.").append(W83bActasBD.codCentro).append(" = ? ");
		params.add(idCentroTrabajo);
		if(StringUtils.isNotEmpty(territorioActa)
				&&StringUtils.isNotEmpty(anyoActa)
				&&StringUtils.isNotEmpty(numActa)
		){
			strSql.append(" AND NOT(actasTemp.").append(W83bActasBD.codTerritActa).append(" = ?");
			params.add(territorioActa);
			strSql.append(" AND actasTemp.").append(W83bActasBD.anyoActa).append(" = ?");
			params.add(new Integer(anyoActa));
			strSql.append(" AND actasTemp.").append(W83bActasBD.numActa).append(" = ?)");
			params.add(new Integer(numActa));
			strSql.append(" AND NOT(actasTemp.").append(W83bActasBD.anyoTotalActa).append(" = ?");
			params.add(new Integer(anyoActa));
			strSql.append(" AND actasTemp.").append(W83bActasBD.numTotalActa).append(" = ?)");
			params.add(new Integer(numActa));
		}
		strSql.append(" and actasTemp.").append(W83bActasBD.fechaBaja).append(" is null ");
		strSql.append(")");
		
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);		
		
		return listaActas;		
	}
	
	public List buscarPreavisosdeCentroTrabajo(W83bCentroTrabajoBean param) throws Exception{
		List listadoPreavisos = new ArrayList();
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("select preavisos.").append(W83bPreavisosBD.c_territ_037).append("||'/'||");
		strSql.append(W83bPreavisosBD.ano_preaviso_037).append("||'/'||");
		strSql.append("TO_CHAR (DECODE (LENGTH (TO_CHAR (preavisos.").append(W83bPreavisosBD.n_preaviso_037).append(")),");
		strSql.append("1, '00000' || TO_CHAR (preavisos.").append(W83bPreavisosBD.n_preaviso_037).append("),");
		strSql.append("2, '0000' || TO_CHAR (preavisos.").append(W83bPreavisosBD.n_preaviso_037).append("),");
		strSql.append("3, '000' || TO_CHAR (preavisos.").append(W83bPreavisosBD.n_preaviso_037).append("),");
		strSql.append("4, '00' || TO_CHAR (preavisos.").append(W83bPreavisosBD.n_preaviso_037).append("),");
		strSql.append("5, '0' || TO_CHAR (preavisos.").append(W83bPreavisosBD.n_preaviso_037).append("),");
		strSql.append("TO_CHAR (preavisos.").append(W83bPreavisosBD.n_preaviso_037).append("))) as numCompleto");
		strSql.append(", to_char(preavisos.").append(W83bPreavisosBD.f_entra_037).append(",?) as ").append("").append(W83bPreavisosBD.f_entra_037);
		strSql.append(", to_char(preavisos.").append(W83bPreavisosBD.f_inicio_037).append(",?) as ").append("").append(W83bPreavisosBD.f_inicio_037);
		strSql.append(", preavisos.").append(W83bPreavisosBD.s_parcial_037);
		strSql.append(", preavisos.").append(W83bPreavisosBD.global_037);
		strSql.append(" from ").append(W83bPreavisosBD.preavisosTable).append(" preavisos ");
		strSql.append(" where preavisos.").append(W83bPreavisosBD.id_centro_037).append(" = ?");
		strSql.append(" and preavisos.").append(W83bPreavisosBD.c_territ_037).append(" = ?");
		
		if(param.getIdColumna()!=null&&!param.getIdColumna().equals("")){
			String[] ordenacion=param.getIdColumna().split(",");
			
			strSql.append(" ORDER BY ");
			for(int i=0;i<ordenacion.length;i++)
			{
				if(i!=0)
				{
					strSql.append(", ");
				}
					strSql.append(" preavisos.").append(ordenacion[i]).append(" ").append(param.getSort());	
			}
		}else{
			strSql.append(" ORDER BY ");
			strSql.append(" numCompleto ").append(" ").append(" asc");	
		}
		
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(param.getCodCentroTrabajo());
		params.add(param.getUsuarioBean().getCodTerritorioDelegacion());
		
		listadoPreavisos = W83bDataBase.executeQuery(strSql.toString(),params,W83bPreavisosBean.class,param.getUsuarioBean(), "CONSULTAPREAVISOCENTROS");
		
		return listadoPreavisos;
	}
	
	public String buscarCentroTrabajoActa(String territorio, String anyo, String numActa, String version) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("select ").append(W83bActasBD.codCentro);
		strSql.append(" from ").append(W83bActasBD.actasTable);
		strSql.append(" where ").append(W83bActasBD.codTerritActa).append(" = ?");
		strSql.append(" and ").append(W83bActasBD.anyoActa).append(" = ?");
		strSql.append(" and ").append(W83bActasBD.numActa).append(" = ?");
		strSql.append(" and ").append(W83bActasBD.versionActa).append(" = ?");
		
		params.add(territorio);
		params.add(new Integer(anyo));
		params.add(new Integer(numActa));
		params.add(new Integer(version));
		
		List listaCentros = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		String centro = (listaCentros.get(0)).toString();
		
		return centro;
	}
	public void descartarIncidenciaActa(String param,W83bUsuarioXLNetsBean usuarioBean,String idioma,String version) throws Exception {
		// TODO Auto-generated method stub
		
		String [] codActa=param.split("_");
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();

		strSql.append("UPDATE ");
		strSql.append(W83bActasBD.incidencias_Synonym);
		strSql.append(" SET ");
		strSql.append(W83bActasBD.inc_validada);
		strSql.append(" = ? ");
		strSql.append(" WHERE ");
		strSql.append(W83bActasBD.inc_numActa);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.inc_anyoActa);
		strSql.append(" = ? ");
		strSql.append(" AND ");
		strSql.append(W83bActasBD.inc_territ);
		strSql.append(" = ? ");
		/*strSql.append(" AND ");
		strSql.append(W83bActasBD.inc_version);
		strSql.append(" = ? ");*/
		strSql.append(" AND ");
		strSql.append(W83bActasBD.inc_validada);
		strSql.append(" = ? ");
		params.add(W83bClsConstantes.CONSTANTE_DESCARTADA);
		params.add(new String(codActa[3]));		
		params.add(new Integer(codActa[2]));
		params.add(codActa[1]);
		//params.add(version);
		params.add(W83bClsConstantes.CONSTANTE_NO_VALIDADA);
		try
		{
			W83bDataBase.executeTableMovement(strSql.toString(), params,usuarioBean);

		}
		catch (SQLException e)
		{
			
		}
		
	}
	
	/**
	 * Devuelve true si el acta pertenece a un centro de menos de treinta trabajadores
	 * @param anyo ao acta
	 * @param territorio territorio acta 
	 * @param numActa numer acta
	 * @param version version acta
	 * @return boolean
	 * @throws Exception the exception
	 */
	public boolean esActaMenorTreintaElectores(String anyo, String territorio, String numActa, String version) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bActasBD.numActa);
		
		strSql.append(" FROM ").append(W83bActasBD.actasTable);
		
		strSql.append(" WHERE ").append(W83bActasBD.anyoActa).append("=?");
		strSql.append(" AND  ").append(W83bActasBD.codTerritActa).append("=?");		
		strSql.append(" AND  ").append(W83bActasBD.numActa).append("=?");
		strSql.append(" AND  ").append(W83bActasBD.versionActa).append("=?");
		strSql.append(" AND  ").append(W83bActasBD.totalElectores).append("<=?");
		params.add(new Integer(anyo));
		params.add(territorio);
		params.add(new Integer(numActa));
		params.add(new Integer(version));
		params.add(new Integer(W83bClsConstantes.TREINTA));
		
		List listaActas = W83bDataBase.executeSimpleQuery(strSql.toString(),params,null);
		
		if(listaActas.size()>0){
			return true;
		}
		
		return false;		
	}
	
	   /**
	    * Actualiza la informacin de acuse de recibo de una comunicacin de un acta
	    * @param docBean W83bDocBean
	    * @throws Exception the exception
	    */
		public void  actualizarDatosAcuseComunicacion(W83bDocBean docBean) throws Exception {
			StringBuffer strSql = new StringBuffer();
			List params = new ArrayList();
			
			strSql.append("UPDATE ");
			strSql.append(W83bActasBD.actas_docsTable);
			strSql.append(" SET ");
			strSql.append(W83bActasBD.id_remesa_acuse_020);
			strSql.append(" = ?, ");
			params.add(docBean.getIdRemesaAcuse());
			strSql.append(W83bActasBD.cod_remesa_acuse_020);
			strSql.append(" = ?, ");
			params.add(docBean.getCodRemesaAcuse());
			strSql.append(W83bActasBD.id_coleccion_acuse_020);
			strSql.append(" = ?, ");
			params.add(docBean.getIdColeccionAcuse());
			strSql.append(W83bActasBD.cod_coleccion_acuse_020);
			strSql.append(" = ?, ");
			params.add(docBean.getCodColeccionAcuse());
			strSql.append(W83bActasBD.id_envio_acuse_020);
			strSql.append(" = ?, ");
			params.add(docBean.getIdEnvioAcuse());
			strSql.append(W83bActasBD.cod_envio_acuse_020);
			strSql.append(" = ? ");
			params.add(docBean.getCodEnvioAcuse());
			strSql.append(" WHERE ").append(W83bActasBD.doc_territActa).append(" = ? ");
			strSql.append(" AND ").append(W83bActasBD.doc_anyoActa).append(" = ? ");
			strSql.append(" AND ").append(W83bActasBD.doc_numActa).append(" = ? ");
			strSql.append(" AND F_REG_020 IN (select max(F_REG_020) from W83B20T00 where ANO_ACTA_020 = ? and N_ACTA_020= ?  and C_TERRIT_020= ? " +
												"and c_tram_020 = ? and c_fase_020 = ? ) ");
			params.add(docBean.getNumActaTerritorio());
			params.add(docBean.getNumActaAno());
			params.add(docBean.getNumActa());
			params.add(docBean.getNumActaAno());
			params.add(docBean.getNumActa());
			params.add(docBean.getNumActaTerritorio());
			params.add(docBean.getCodTramite());
			params.add(docBean.getCodFase());
			W83bDataBase.executeTableMovement(strSql.toString(), params, null);
		}

}
